/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient;
import software.amazon.awssdk.services.appmesh.model.ListMeshesRequest;
import software.amazon.awssdk.services.appmesh.model.ListMeshesResponse;
import software.amazon.awssdk.services.appmesh.model.MeshRef;

public class ListMeshesPublisher
implements SdkPublisher<ListMeshesResponse> {
    private final AppMeshAsyncClient client;
    private final ListMeshesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMeshesPublisher(AppMeshAsyncClient client, ListMeshesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMeshesPublisher(AppMeshAsyncClient client, ListMeshesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMeshesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMeshesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MeshRef> meshes() {
        Function<ListMeshesResponse, Iterator> getIterator = response -> {
            if (response != null && response.meshes() != null) {
                return response.meshes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMeshesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListMeshesPublisher resume(ListMeshesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMeshesPublisher(this.client, (ListMeshesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListMeshesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListMeshesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListMeshesResponseFetcher
    implements AsyncPageFetcher<ListMeshesResponse> {
        private ListMeshesResponseFetcher() {
        }

        public boolean hasNextPage(ListMeshesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMeshesResponse> nextPage(ListMeshesResponse previousPage) {
            if (previousPage == null) {
                return ListMeshesPublisher.this.client.listMeshes(ListMeshesPublisher.this.firstRequest);
            }
            return ListMeshesPublisher.this.client.listMeshes((ListMeshesRequest)((Object)ListMeshesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

