/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.ListRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.RouteRef;

public class ListRoutesIterable
implements SdkIterable<ListRoutesResponse> {
    private final AppMeshClient client;
    private final ListRoutesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoutesIterable(AppMeshClient client, ListRoutesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoutesResponseFetcher();
    }

    public Iterator<ListRoutesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RouteRef> routes() {
        Function<ListRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routes() != null) {
                return response.routes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoutesResponseFetcher
    implements SyncPageFetcher<ListRoutesResponse> {
        private ListRoutesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoutesResponse nextPage(ListRoutesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutesIterable.this.client.listRoutes(ListRoutesIterable.this.firstRequest);
            }
            return ListRoutesIterable.this.client.listRoutes((ListRoutesRequest)((Object)ListRoutesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

