/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the service discovery information for a virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceDiscovery implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceDiscovery.Builder, ServiceDiscovery> {
    private static final SdkField<AwsCloudMapServiceDiscovery> AWS_CLOUD_MAP_FIELD = SdkField
            .<AwsCloudMapServiceDiscovery> builder(MarshallingType.SDK_POJO).memberName("awsCloudMap")
            .getter(getter(ServiceDiscovery::awsCloudMap)).setter(setter(Builder::awsCloudMap))
            .constructor(AwsCloudMapServiceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsCloudMap").build()).build();

    private static final SdkField<DnsServiceDiscovery> DNS_FIELD = SdkField
            .<DnsServiceDiscovery> builder(MarshallingType.SDK_POJO).memberName("dns").getter(getter(ServiceDiscovery::dns))
            .setter(setter(Builder::dns)).constructor(DnsServiceDiscovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AWS_CLOUD_MAP_FIELD, DNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsCloudMapServiceDiscovery awsCloudMap;

    private final DnsServiceDiscovery dns;

    private final Type type;

    private ServiceDiscovery(BuilderImpl builder) {
        this.awsCloudMap = builder.awsCloudMap;
        this.dns = builder.dns;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies any Cloud Map information for the virtual node.
     * </p>
     * 
     * @return Specifies any Cloud Map information for the virtual node.
     */
    public final AwsCloudMapServiceDiscovery awsCloudMap() {
        return awsCloudMap;
    }

    /**
     * <p>
     * Specifies the DNS information for the virtual node.
     * </p>
     * 
     * @return Specifies the DNS information for the virtual node.
     */
    public final DnsServiceDiscovery dns() {
        return dns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudMap());
        hashCode = 31 * hashCode + Objects.hashCode(dns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDiscovery)) {
            return false;
        }
        ServiceDiscovery other = (ServiceDiscovery) obj;
        return Objects.equals(awsCloudMap(), other.awsCloudMap()) && Objects.equals(dns(), other.dns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceDiscovery").add("AwsCloudMap", awsCloudMap()).add("Dns", dns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsCloudMap":
            return Optional.ofNullable(clazz.cast(awsCloudMap()));
        case "dns":
            return Optional.ofNullable(clazz.cast(dns()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsCloudMap()} initialized to the given value.
     *
     * <p>
     * Specifies any Cloud Map information for the virtual node.
     * </p>
     * 
     * @param awsCloudMap
     *        Specifies any Cloud Map information for the virtual node.
     */
    public static ServiceDiscovery fromAwsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap) {
        return builder().awsCloudMap(awsCloudMap).build();
    }

    /**
     * Create an instance of this class with {@link #awsCloudMap()} initialized to the given value.
     *
     * <p>
     * Specifies any Cloud Map information for the virtual node.
     * </p>
     * 
     * @param awsCloudMap
     *        Specifies any Cloud Map information for the virtual node.
     */
    public static ServiceDiscovery fromAwsCloudMap(Consumer<AwsCloudMapServiceDiscovery.Builder> awsCloudMap) {
        AwsCloudMapServiceDiscovery.Builder builder = AwsCloudMapServiceDiscovery.builder();
        awsCloudMap.accept(builder);
        return fromAwsCloudMap(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dns()} initialized to the given value.
     *
     * <p>
     * Specifies the DNS information for the virtual node.
     * </p>
     * 
     * @param dns
     *        Specifies the DNS information for the virtual node.
     */
    public static ServiceDiscovery fromDns(DnsServiceDiscovery dns) {
        return builder().dns(dns).build();
    }

    /**
     * Create an instance of this class with {@link #dns()} initialized to the given value.
     *
     * <p>
     * Specifies the DNS information for the virtual node.
     * </p>
     * 
     * @param dns
     *        Specifies the DNS information for the virtual node.
     */
    public static ServiceDiscovery fromDns(Consumer<DnsServiceDiscovery.Builder> dns) {
        DnsServiceDiscovery.Builder builder = DnsServiceDiscovery.builder();
        dns.accept(builder);
        return fromDns(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsCloudMap", AWS_CLOUD_MAP_FIELD);
        map.put("dns", DNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDiscovery, T> g) {
        return obj -> g.apply((ServiceDiscovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceDiscovery> {
        /**
         * <p>
         * Specifies any Cloud Map information for the virtual node.
         * </p>
         * 
         * @param awsCloudMap
         *        Specifies any Cloud Map information for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap);

        /**
         * <p>
         * Specifies any Cloud Map information for the virtual node.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudMapServiceDiscovery.Builder}
         * avoiding the need to create one manually via {@link AwsCloudMapServiceDiscovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudMapServiceDiscovery.Builder#build()} is called
         * immediately and its result is passed to {@link #awsCloudMap(AwsCloudMapServiceDiscovery)}.
         * 
         * @param awsCloudMap
         *        a consumer that will call methods on {@link AwsCloudMapServiceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudMap(AwsCloudMapServiceDiscovery)
         */
        default Builder awsCloudMap(Consumer<AwsCloudMapServiceDiscovery.Builder> awsCloudMap) {
            return awsCloudMap(AwsCloudMapServiceDiscovery.builder().applyMutation(awsCloudMap).build());
        }

        /**
         * <p>
         * Specifies the DNS information for the virtual node.
         * </p>
         * 
         * @param dns
         *        Specifies the DNS information for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dns(DnsServiceDiscovery dns);

        /**
         * <p>
         * Specifies the DNS information for the virtual node.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsServiceDiscovery.Builder} avoiding the
         * need to create one manually via {@link DnsServiceDiscovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsServiceDiscovery.Builder#build()} is called immediately and
         * its result is passed to {@link #dns(DnsServiceDiscovery)}.
         * 
         * @param dns
         *        a consumer that will call methods on {@link DnsServiceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dns(DnsServiceDiscovery)
         */
        default Builder dns(Consumer<DnsServiceDiscovery.Builder> dns) {
            return dns(DnsServiceDiscovery.builder().applyMutation(dns).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsCloudMapServiceDiscovery awsCloudMap;

        private DnsServiceDiscovery dns;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDiscovery model) {
            awsCloudMap(model.awsCloudMap);
            dns(model.dns);
        }

        public final AwsCloudMapServiceDiscovery.Builder getAwsCloudMap() {
            return awsCloudMap != null ? awsCloudMap.toBuilder() : null;
        }

        public final void setAwsCloudMap(AwsCloudMapServiceDiscovery.BuilderImpl awsCloudMap) {
            Object oldValue = this.awsCloudMap;
            this.awsCloudMap = awsCloudMap != null ? awsCloudMap.build() : null;
            handleUnionValueChange(Type.AWS_CLOUD_MAP, oldValue, this.awsCloudMap);
        }

        @Override
        public final Builder awsCloudMap(AwsCloudMapServiceDiscovery awsCloudMap) {
            Object oldValue = this.awsCloudMap;
            this.awsCloudMap = awsCloudMap;
            handleUnionValueChange(Type.AWS_CLOUD_MAP, oldValue, this.awsCloudMap);
            return this;
        }

        public final DnsServiceDiscovery.Builder getDns() {
            return dns != null ? dns.toBuilder() : null;
        }

        public final void setDns(DnsServiceDiscovery.BuilderImpl dns) {
            Object oldValue = this.dns;
            this.dns = dns != null ? dns.build() : null;
            handleUnionValueChange(Type.DNS, oldValue, this.dns);
        }

        @Override
        public final Builder dns(DnsServiceDiscovery dns) {
            Object oldValue = this.dns;
            this.dns = dns;
            handleUnionValueChange(Type.DNS, oldValue, this.dns);
            return this;
        }

        @Override
        public ServiceDiscovery build() {
            return new ServiceDiscovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ServiceDiscovery#type()
     */
    public enum Type {
        AWS_CLOUD_MAP,

        DNS,

        UNKNOWN_TO_SDK_VERSION
    }
}
