/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMeshResponse extends AppMeshResponse implements
        ToCopyableBuilder<DescribeMeshResponse.Builder, DescribeMeshResponse> {
    private static final SdkField<MeshData> MESH_FIELD = SdkField
            .<MeshData> builder(MarshallingType.SDK_POJO)
            .memberName("mesh")
            .getter(getter(DescribeMeshResponse::mesh))
            .setter(setter(Builder::mesh))
            .constructor(MeshData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mesh").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MeshData mesh;

    private DescribeMeshResponse(BuilderImpl builder) {
        super(builder);
        this.mesh = builder.mesh;
    }

    /**
     * <p>
     * The full description of your service mesh.
     * </p>
     * 
     * @return The full description of your service mesh.
     */
    public final MeshData mesh() {
        return mesh;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mesh());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMeshResponse)) {
            return false;
        }
        DescribeMeshResponse other = (DescribeMeshResponse) obj;
        return Objects.equals(mesh(), other.mesh());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMeshResponse").add("Mesh", mesh()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mesh":
            return Optional.ofNullable(clazz.cast(mesh()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mesh", MESH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMeshResponse, T> g) {
        return obj -> g.apply((DescribeMeshResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMeshResponse> {
        /**
         * <p>
         * The full description of your service mesh.
         * </p>
         * 
         * @param mesh
         *        The full description of your service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mesh(MeshData mesh);

        /**
         * <p>
         * The full description of your service mesh.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeshData.Builder} avoiding the need to
         * create one manually via {@link MeshData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeshData.Builder#build()} is called immediately and its result is
         * passed to {@link #mesh(MeshData)}.
         * 
         * @param mesh
         *        a consumer that will call methods on {@link MeshData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mesh(MeshData)
         */
        default Builder mesh(Consumer<MeshData.Builder> mesh) {
            return mesh(MeshData.builder().applyMutation(mesh).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private MeshData mesh;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMeshResponse model) {
            super(model);
            mesh(model.mesh);
        }

        public final MeshData.Builder getMesh() {
            return mesh != null ? mesh.toBuilder() : null;
        }

        public final void setMesh(MeshData.BuilderImpl mesh) {
            this.mesh = mesh != null ? mesh.build() : null;
        }

        @Override
        public final Builder mesh(MeshData mesh) {
            this.mesh = mesh;
            return this;
        }

        @Override
        public DescribeMeshResponse build() {
            return new DescribeMeshResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
