/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the action to take if a match is determined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TcpRouteAction implements SdkPojo, Serializable, ToCopyableBuilder<TcpRouteAction.Builder, TcpRouteAction> {
    private static final SdkField<List<WeightedTarget>> WEIGHTED_TARGETS_FIELD = SdkField
            .<List<WeightedTarget>> builder(MarshallingType.LIST)
            .memberName("weightedTargets")
            .getter(getter(TcpRouteAction::weightedTargets))
            .setter(setter(Builder::weightedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weightedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WeightedTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(WeightedTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHTED_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<WeightedTarget> weightedTargets;

    private TcpRouteAction(BuilderImpl builder) {
        this.weightedTargets = builder.weightedTargets;
    }

    /**
     * For responses, this returns true if the service returned a value for the WeightedTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWeightedTargets() {
        return weightedTargets != null && !(weightedTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that represents the targets that traffic is routed to when a request matches the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWeightedTargets} method.
     * </p>
     * 
     * @return An object that represents the targets that traffic is routed to when a request matches the route.
     */
    public final List<WeightedTarget> weightedTargets() {
        return weightedTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWeightedTargets() ? weightedTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TcpRouteAction)) {
            return false;
        }
        TcpRouteAction other = (TcpRouteAction) obj;
        return hasWeightedTargets() == other.hasWeightedTargets() && Objects.equals(weightedTargets(), other.weightedTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TcpRouteAction").add("WeightedTargets", hasWeightedTargets() ? weightedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "weightedTargets":
            return Optional.ofNullable(clazz.cast(weightedTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("weightedTargets", WEIGHTED_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TcpRouteAction, T> g) {
        return obj -> g.apply((TcpRouteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TcpRouteAction> {
        /**
         * <p>
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * </p>
         * 
         * @param weightedTargets
         *        An object that represents the targets that traffic is routed to when a request matches the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedTargets(Collection<WeightedTarget> weightedTargets);

        /**
         * <p>
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * </p>
         * 
         * @param weightedTargets
         *        An object that represents the targets that traffic is routed to when a request matches the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedTargets(WeightedTarget... weightedTargets);

        /**
         * <p>
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appmesh.model.WeightedTarget.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appmesh.model.WeightedTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appmesh.model.WeightedTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #weightedTargets(List<WeightedTarget>)}.
         * 
         * @param weightedTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appmesh.model.WeightedTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weightedTargets(java.util.Collection<WeightedTarget>)
         */
        Builder weightedTargets(Consumer<WeightedTarget.Builder>... weightedTargets);
    }

    static final class BuilderImpl implements Builder {
        private List<WeightedTarget> weightedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TcpRouteAction model) {
            weightedTargets(model.weightedTargets);
        }

        public final List<WeightedTarget.Builder> getWeightedTargets() {
            List<WeightedTarget.Builder> result = WeightedTargetsCopier.copyToBuilder(this.weightedTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeightedTargets(Collection<WeightedTarget.BuilderImpl> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copyFromBuilder(weightedTargets);
        }

        @Override
        public final Builder weightedTargets(Collection<WeightedTarget> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copy(weightedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(WeightedTarget... weightedTargets) {
            weightedTargets(Arrays.asList(weightedTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(Consumer<WeightedTarget.Builder>... weightedTargets) {
            weightedTargets(Stream.of(weightedTargets).map(c -> WeightedTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TcpRouteAction build() {
            return new TcpRouteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
