/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the beginning characters of the route to rewrite.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpGatewayRoutePrefixRewrite implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpGatewayRoutePrefixRewrite.Builder, HttpGatewayRoutePrefixRewrite> {
    private static final SdkField<String> DEFAULT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultPrefix").getter(getter(HttpGatewayRoutePrefixRewrite::defaultPrefixAsString))
            .setter(setter(Builder::defaultPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPrefix").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(HttpGatewayRoutePrefixRewrite::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_PREFIX_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultPrefix;

    private final String value;

    private HttpGatewayRoutePrefixRewrite(BuilderImpl builder) {
        this.defaultPrefix = builder.defaultPrefix;
        this.value = builder.value;
    }

    /**
     * <p>
     * The default prefix used to replace the incoming route prefix when rewritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultPrefix}
     * will return {@link DefaultGatewayRouteRewrite#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultPrefixAsString}.
     * </p>
     * 
     * @return The default prefix used to replace the incoming route prefix when rewritten.
     * @see DefaultGatewayRouteRewrite
     */
    public final DefaultGatewayRouteRewrite defaultPrefix() {
        return DefaultGatewayRouteRewrite.fromValue(defaultPrefix);
    }

    /**
     * <p>
     * The default prefix used to replace the incoming route prefix when rewritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultPrefix}
     * will return {@link DefaultGatewayRouteRewrite#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultPrefixAsString}.
     * </p>
     * 
     * @return The default prefix used to replace the incoming route prefix when rewritten.
     * @see DefaultGatewayRouteRewrite
     */
    public final String defaultPrefixAsString() {
        return defaultPrefix;
    }

    /**
     * <p>
     * The value used to replace the incoming route prefix when rewritten.
     * </p>
     * 
     * @return The value used to replace the incoming route prefix when rewritten.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultPrefixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRoutePrefixRewrite)) {
            return false;
        }
        HttpGatewayRoutePrefixRewrite other = (HttpGatewayRoutePrefixRewrite) obj;
        return Objects.equals(defaultPrefixAsString(), other.defaultPrefixAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpGatewayRoutePrefixRewrite").add("DefaultPrefix", defaultPrefixAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultPrefix":
            return Optional.ofNullable(clazz.cast(defaultPrefixAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultPrefix", DEFAULT_PREFIX_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRoutePrefixRewrite, T> g) {
        return obj -> g.apply((HttpGatewayRoutePrefixRewrite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpGatewayRoutePrefixRewrite> {
        /**
         * <p>
         * The default prefix used to replace the incoming route prefix when rewritten.
         * </p>
         * 
         * @param defaultPrefix
         *        The default prefix used to replace the incoming route prefix when rewritten.
         * @see DefaultGatewayRouteRewrite
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultGatewayRouteRewrite
         */
        Builder defaultPrefix(String defaultPrefix);

        /**
         * <p>
         * The default prefix used to replace the incoming route prefix when rewritten.
         * </p>
         * 
         * @param defaultPrefix
         *        The default prefix used to replace the incoming route prefix when rewritten.
         * @see DefaultGatewayRouteRewrite
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultGatewayRouteRewrite
         */
        Builder defaultPrefix(DefaultGatewayRouteRewrite defaultPrefix);

        /**
         * <p>
         * The value used to replace the incoming route prefix when rewritten.
         * </p>
         * 
         * @param value
         *        The value used to replace the incoming route prefix when rewritten.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String defaultPrefix;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRoutePrefixRewrite model) {
            defaultPrefix(model.defaultPrefix);
            value(model.value);
        }

        public final String getDefaultPrefix() {
            return defaultPrefix;
        }

        public final void setDefaultPrefix(String defaultPrefix) {
            this.defaultPrefix = defaultPrefix;
        }

        @Override
        public final Builder defaultPrefix(String defaultPrefix) {
            this.defaultPrefix = defaultPrefix;
            return this;
        }

        @Override
        public final Builder defaultPrefix(DefaultGatewayRouteRewrite defaultPrefix) {
            this.defaultPrefix(defaultPrefix == null ? null : defaultPrefix.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public HttpGatewayRoutePrefixRewrite build() {
            return new HttpGatewayRoutePrefixRewrite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
