/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsAcmCertificate;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewayListenerTlsCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewayListenerTlsCertificate> {
    private static final SdkField<VirtualGatewayListenerTlsAcmCertificate> ACM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acm").getter(VirtualGatewayListenerTlsCertificate.getter(VirtualGatewayListenerTlsCertificate::acm)).setter(VirtualGatewayListenerTlsCertificate.setter(Builder::acm)).constructor(VirtualGatewayListenerTlsAcmCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()}).build();
    private static final SdkField<VirtualGatewayListenerTlsFileCertificate> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(VirtualGatewayListenerTlsCertificate.getter(VirtualGatewayListenerTlsCertificate::file)).setter(VirtualGatewayListenerTlsCertificate.setter(Builder::file)).constructor(VirtualGatewayListenerTlsFileCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<VirtualGatewayListenerTlsSdsCertificate> SDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sds").getter(VirtualGatewayListenerTlsCertificate.getter(VirtualGatewayListenerTlsCertificate::sds)).setter(VirtualGatewayListenerTlsCertificate.setter(Builder::sds)).constructor(VirtualGatewayListenerTlsSdsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD, SDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VirtualGatewayListenerTlsCertificate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VirtualGatewayListenerTlsAcmCertificate acm;
    private final VirtualGatewayListenerTlsFileCertificate file;
    private final VirtualGatewayListenerTlsSdsCertificate sds;
    private final Type type;

    private VirtualGatewayListenerTlsCertificate(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    public final VirtualGatewayListenerTlsAcmCertificate acm() {
        return this.acm;
    }

    public final VirtualGatewayListenerTlsFileCertificate file() {
        return this.file;
    }

    public final VirtualGatewayListenerTlsSdsCertificate sds() {
        return this.sds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acm());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListenerTlsCertificate)) {
            return false;
        }
        VirtualGatewayListenerTlsCertificate other = (VirtualGatewayListenerTlsCertificate)obj;
        return Objects.equals(this.acm(), other.acm()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.sds(), other.sds());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualGatewayListenerTlsCertificate").add("Acm", (Object)this.acm()).add("File", (Object)this.file()).add("Sds", (Object)this.sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acm": {
                return Optional.ofNullable(clazz.cast(this.acm()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sds": {
                return Optional.ofNullable(clazz.cast(this.sds()));
            }
        }
        return Optional.empty();
    }

    public static VirtualGatewayListenerTlsCertificate fromAcm(VirtualGatewayListenerTlsAcmCertificate acm) {
        return (VirtualGatewayListenerTlsCertificate)VirtualGatewayListenerTlsCertificate.builder().acm(acm).build();
    }

    public static VirtualGatewayListenerTlsCertificate fromAcm(Consumer<VirtualGatewayListenerTlsAcmCertificate.Builder> acm) {
        VirtualGatewayListenerTlsAcmCertificate.Builder builder = VirtualGatewayListenerTlsAcmCertificate.builder();
        acm.accept(builder);
        return VirtualGatewayListenerTlsCertificate.fromAcm((VirtualGatewayListenerTlsAcmCertificate)builder.build());
    }

    public static VirtualGatewayListenerTlsCertificate fromFile(VirtualGatewayListenerTlsFileCertificate file) {
        return (VirtualGatewayListenerTlsCertificate)VirtualGatewayListenerTlsCertificate.builder().file(file).build();
    }

    public static VirtualGatewayListenerTlsCertificate fromFile(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
        VirtualGatewayListenerTlsFileCertificate.Builder builder = VirtualGatewayListenerTlsFileCertificate.builder();
        file.accept(builder);
        return VirtualGatewayListenerTlsCertificate.fromFile((VirtualGatewayListenerTlsFileCertificate)builder.build());
    }

    public static VirtualGatewayListenerTlsCertificate fromSds(VirtualGatewayListenerTlsSdsCertificate sds) {
        return (VirtualGatewayListenerTlsCertificate)VirtualGatewayListenerTlsCertificate.builder().sds(sds).build();
    }

    public static VirtualGatewayListenerTlsCertificate fromSds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
        VirtualGatewayListenerTlsSdsCertificate.Builder builder = VirtualGatewayListenerTlsSdsCertificate.builder();
        sds.accept(builder);
        return VirtualGatewayListenerTlsCertificate.fromSds((VirtualGatewayListenerTlsSdsCertificate)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acm", ACM_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sds", SDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListenerTlsCertificate, T> g) {
        return obj -> g.apply((VirtualGatewayListenerTlsCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACM,
        FILE,
        SDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VirtualGatewayListenerTlsAcmCertificate acm;
        private VirtualGatewayListenerTlsFileCertificate file;
        private VirtualGatewayListenerTlsSdsCertificate sds;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListenerTlsCertificate model) {
            this.acm(model.acm);
            this.file(model.file);
            this.sds(model.sds);
        }

        public final VirtualGatewayListenerTlsAcmCertificate.Builder getAcm() {
            return this.acm != null ? this.acm.toBuilder() : null;
        }

        public final void setAcm(VirtualGatewayListenerTlsAcmCertificate.BuilderImpl acm) {
            VirtualGatewayListenerTlsAcmCertificate oldValue = this.acm;
            this.acm = acm != null ? acm.build() : null;
            this.handleUnionValueChange(Type.ACM, oldValue, this.acm);
        }

        @Override
        public final Builder acm(VirtualGatewayListenerTlsAcmCertificate acm) {
            VirtualGatewayListenerTlsAcmCertificate oldValue = this.acm;
            this.acm = acm;
            this.handleUnionValueChange(Type.ACM, oldValue, this.acm);
            return this;
        }

        public final VirtualGatewayListenerTlsFileCertificate.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(VirtualGatewayListenerTlsFileCertificate.BuilderImpl file) {
            VirtualGatewayListenerTlsFileCertificate oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(VirtualGatewayListenerTlsFileCertificate file) {
            VirtualGatewayListenerTlsFileCertificate oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final VirtualGatewayListenerTlsSdsCertificate.Builder getSds() {
            return this.sds != null ? this.sds.toBuilder() : null;
        }

        public final void setSds(VirtualGatewayListenerTlsSdsCertificate.BuilderImpl sds) {
            VirtualGatewayListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        public final Builder sds(VirtualGatewayListenerTlsSdsCertificate sds) {
            VirtualGatewayListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        public VirtualGatewayListenerTlsCertificate build() {
            return new VirtualGatewayListenerTlsCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewayListenerTlsCertificate> {
        public Builder acm(VirtualGatewayListenerTlsAcmCertificate var1);

        default public Builder acm(Consumer<VirtualGatewayListenerTlsAcmCertificate.Builder> acm) {
            return this.acm((VirtualGatewayListenerTlsAcmCertificate)((VirtualGatewayListenerTlsAcmCertificate.Builder)VirtualGatewayListenerTlsAcmCertificate.builder().applyMutation(acm)).build());
        }

        public Builder file(VirtualGatewayListenerTlsFileCertificate var1);

        default public Builder file(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
            return this.file((VirtualGatewayListenerTlsFileCertificate)((VirtualGatewayListenerTlsFileCertificate.Builder)VirtualGatewayListenerTlsFileCertificate.builder().applyMutation(file)).build());
        }

        public Builder sds(VirtualGatewayListenerTlsSdsCertificate var1);

        default public Builder sds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
            return this.sds((VirtualGatewayListenerTlsSdsCertificate)((VirtualGatewayListenerTlsSdsCertificate.Builder)VirtualGatewayListenerTlsSdsCertificate.builder().applyMutation(sds)).build());
        }
    }
}

