/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.GrpcGatewayRoute;
import software.amazon.awssdk.services.appmesh.model.HttpGatewayRoute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayRouteSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayRouteSpec> {
    private static final SdkField<GrpcGatewayRoute> GRPC_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grpcRoute").getter(GatewayRouteSpec.getter(GatewayRouteSpec::grpcRoute)).setter(GatewayRouteSpec.setter(Builder::grpcRoute)).constructor(GrpcGatewayRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpcRoute").build()}).build();
    private static final SdkField<HttpGatewayRoute> HTTP2_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("http2Route").getter(GatewayRouteSpec.getter(GatewayRouteSpec::http2Route)).setter(GatewayRouteSpec.setter(Builder::http2Route)).constructor(HttpGatewayRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2Route").build()}).build();
    private static final SdkField<HttpGatewayRoute> HTTP_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpRoute").getter(GatewayRouteSpec.getter(GatewayRouteSpec::httpRoute)).setter(GatewayRouteSpec.setter(Builder::httpRoute)).constructor(HttpGatewayRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRoute").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(GatewayRouteSpec.getter(GatewayRouteSpec::priority)).setter(GatewayRouteSpec.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_ROUTE_FIELD, HTTP2_ROUTE_FIELD, HTTP_ROUTE_FIELD, PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewayRouteSpec.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GrpcGatewayRoute grpcRoute;
    private final HttpGatewayRoute http2Route;
    private final HttpGatewayRoute httpRoute;
    private final Integer priority;

    private GatewayRouteSpec(BuilderImpl builder) {
        this.grpcRoute = builder.grpcRoute;
        this.http2Route = builder.http2Route;
        this.httpRoute = builder.httpRoute;
        this.priority = builder.priority;
    }

    public final GrpcGatewayRoute grpcRoute() {
        return this.grpcRoute;
    }

    public final HttpGatewayRoute http2Route() {
        return this.http2Route;
    }

    public final HttpGatewayRoute httpRoute() {
        return this.httpRoute;
    }

    public final Integer priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grpcRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.http2Route());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayRouteSpec)) {
            return false;
        }
        GatewayRouteSpec other = (GatewayRouteSpec)obj;
        return Objects.equals(this.grpcRoute(), other.grpcRoute()) && Objects.equals(this.http2Route(), other.http2Route()) && Objects.equals(this.httpRoute(), other.httpRoute()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayRouteSpec").add("GrpcRoute", (Object)this.grpcRoute()).add("Http2Route", (Object)this.http2Route()).add("HttpRoute", (Object)this.httpRoute()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grpcRoute": {
                return Optional.ofNullable(clazz.cast(this.grpcRoute()));
            }
            case "http2Route": {
                return Optional.ofNullable(clazz.cast(this.http2Route()));
            }
            case "httpRoute": {
                return Optional.ofNullable(clazz.cast(this.httpRoute()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("grpcRoute", GRPC_ROUTE_FIELD);
        map.put("http2Route", HTTP2_ROUTE_FIELD);
        map.put("httpRoute", HTTP_ROUTE_FIELD);
        map.put("priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayRouteSpec, T> g) {
        return obj -> g.apply((GatewayRouteSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GrpcGatewayRoute grpcRoute;
        private HttpGatewayRoute http2Route;
        private HttpGatewayRoute httpRoute;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayRouteSpec model) {
            this.grpcRoute(model.grpcRoute);
            this.http2Route(model.http2Route);
            this.httpRoute(model.httpRoute);
            this.priority(model.priority);
        }

        public final GrpcGatewayRoute.Builder getGrpcRoute() {
            return this.grpcRoute != null ? this.grpcRoute.toBuilder() : null;
        }

        public final void setGrpcRoute(GrpcGatewayRoute.BuilderImpl grpcRoute) {
            this.grpcRoute = grpcRoute != null ? grpcRoute.build() : null;
        }

        @Override
        public final Builder grpcRoute(GrpcGatewayRoute grpcRoute) {
            this.grpcRoute = grpcRoute;
            return this;
        }

        public final HttpGatewayRoute.Builder getHttp2Route() {
            return this.http2Route != null ? this.http2Route.toBuilder() : null;
        }

        public final void setHttp2Route(HttpGatewayRoute.BuilderImpl http2Route) {
            this.http2Route = http2Route != null ? http2Route.build() : null;
        }

        @Override
        public final Builder http2Route(HttpGatewayRoute http2Route) {
            this.http2Route = http2Route;
            return this;
        }

        public final HttpGatewayRoute.Builder getHttpRoute() {
            return this.httpRoute != null ? this.httpRoute.toBuilder() : null;
        }

        public final void setHttpRoute(HttpGatewayRoute.BuilderImpl httpRoute) {
            this.httpRoute = httpRoute != null ? httpRoute.build() : null;
        }

        @Override
        public final Builder httpRoute(HttpGatewayRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public GatewayRouteSpec build() {
            return new GatewayRouteSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayRouteSpec> {
        public Builder grpcRoute(GrpcGatewayRoute var1);

        default public Builder grpcRoute(Consumer<GrpcGatewayRoute.Builder> grpcRoute) {
            return this.grpcRoute((GrpcGatewayRoute)((GrpcGatewayRoute.Builder)GrpcGatewayRoute.builder().applyMutation(grpcRoute)).build());
        }

        public Builder http2Route(HttpGatewayRoute var1);

        default public Builder http2Route(Consumer<HttpGatewayRoute.Builder> http2Route) {
            return this.http2Route((HttpGatewayRoute)((HttpGatewayRoute.Builder)HttpGatewayRoute.builder().applyMutation(http2Route)).build());
        }

        public Builder httpRoute(HttpGatewayRoute var1);

        default public Builder httpRoute(Consumer<HttpGatewayRoute.Builder> httpRoute) {
            return this.httpRoute((HttpGatewayRoute)((HttpGatewayRoute.Builder)HttpGatewayRoute.builder().applyMutation(httpRoute)).build());
        }

        public Builder priority(Integer var1);
    }
}

