/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.VirtualServiceBackend;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Backend
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Backend> {
    private static final SdkField<VirtualServiceBackend> VIRTUAL_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("virtualService").getter(Backend.getter(Backend::virtualService)).setter(Backend.setter(Builder::virtualService)).constructor(VirtualServiceBackend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_SERVICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Backend.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VirtualServiceBackend virtualService;
    private final Type type;

    private Backend(BuilderImpl builder) {
        this.virtualService = builder.virtualService;
        this.type = builder.type;
    }

    public final VirtualServiceBackend virtualService() {
        return this.virtualService;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualService());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backend)) {
            return false;
        }
        Backend other = (Backend)obj;
        return Objects.equals(this.virtualService(), other.virtualService());
    }

    public final String toString() {
        return ToString.builder((String)"Backend").add("VirtualService", (Object)this.virtualService()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualService": {
                return Optional.ofNullable(clazz.cast(this.virtualService()));
            }
        }
        return Optional.empty();
    }

    public static Backend fromVirtualService(VirtualServiceBackend virtualService) {
        return (Backend)Backend.builder().virtualService(virtualService).build();
    }

    public static Backend fromVirtualService(Consumer<VirtualServiceBackend.Builder> virtualService) {
        VirtualServiceBackend.Builder builder = VirtualServiceBackend.builder();
        virtualService.accept(builder);
        return Backend.fromVirtualService((VirtualServiceBackend)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<VirtualServiceBackend>> map = new HashMap<String, SdkField<VirtualServiceBackend>>();
        map.put("virtualService", VIRTUAL_SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Backend, T> g) {
        return obj -> g.apply((Backend)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VIRTUAL_SERVICE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VirtualServiceBackend virtualService;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Backend model) {
            this.virtualService(model.virtualService);
        }

        public final VirtualServiceBackend.Builder getVirtualService() {
            return this.virtualService != null ? this.virtualService.toBuilder() : null;
        }

        public final void setVirtualService(VirtualServiceBackend.BuilderImpl virtualService) {
            VirtualServiceBackend oldValue = this.virtualService;
            this.virtualService = virtualService != null ? virtualService.build() : null;
            this.handleUnionValueChange(Type.VIRTUAL_SERVICE, oldValue, this.virtualService);
        }

        @Override
        public final Builder virtualService(VirtualServiceBackend virtualService) {
            VirtualServiceBackend oldValue = this.virtualService;
            this.virtualService = virtualService;
            this.handleUnionValueChange(Type.VIRTUAL_SERVICE, oldValue, this.virtualService);
            return this;
        }

        public Backend build() {
            return new Backend(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Backend> {
        public Builder virtualService(VirtualServiceBackend var1);

        default public Builder virtualService(Consumer<VirtualServiceBackend.Builder> virtualService) {
            return this.virtualService((VirtualServiceBackend)((VirtualServiceBackend.Builder)VirtualServiceBackend.builder().applyMutation(virtualService)).build());
        }
    }
}

