/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeRef;

public class ListVirtualNodesPublisher
implements SdkPublisher<ListVirtualNodesResponse> {
    private final AppMeshAsyncClient client;
    private final ListVirtualNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualNodesPublisher(AppMeshAsyncClient client, ListVirtualNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualNodesPublisher(AppMeshAsyncClient client, ListVirtualNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualNodeRef> virtualNodes() {
        Function<ListVirtualNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualNodes() != null) {
                return response.virtualNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListVirtualNodesPublisher resume(ListVirtualNodesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVirtualNodesPublisher(this.client, (ListVirtualNodesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListVirtualNodesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListVirtualNodesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListVirtualNodesResponseFetcher
    implements AsyncPageFetcher<ListVirtualNodesResponse> {
        private ListVirtualNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVirtualNodesResponse> nextPage(ListVirtualNodesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualNodesPublisher.this.client.listVirtualNodes(ListVirtualNodesPublisher.this.firstRequest);
            }
            return ListVirtualNodesPublisher.this.client.listVirtualNodes((ListVirtualNodesRequest)((Object)ListVirtualNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

