/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeRef;

public class ListVirtualNodesIterable
implements SdkIterable<ListVirtualNodesResponse> {
    private final AppMeshClient client;
    private final ListVirtualNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualNodesIterable(AppMeshClient client, ListVirtualNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVirtualNodesResponseFetcher();
    }

    public Iterator<ListVirtualNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualNodeRef> virtualNodes() {
        Function<ListVirtualNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualNodes() != null) {
                return response.virtualNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListVirtualNodesIterable resume(ListVirtualNodesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVirtualNodesIterable(this.client, (ListVirtualNodesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListVirtualNodesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListVirtualNodesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListVirtualNodesResponseFetcher
    implements SyncPageFetcher<ListVirtualNodesResponse> {
        private ListVirtualNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVirtualNodesResponse nextPage(ListVirtualNodesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualNodesIterable.this.client.listVirtualNodes(ListVirtualNodesIterable.this.firstRequest);
            }
            return ListVirtualNodesIterable.this.client.listVirtualNodes((ListVirtualNodesRequest)((Object)ListVirtualNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

