/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayGrpcConnectionPool;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttp2ConnectionPool;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayHttpConnectionPool;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewayConnectionPool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewayConnectionPool> {
    private static final SdkField<VirtualGatewayGrpcConnectionPool> GRPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grpc").getter(VirtualGatewayConnectionPool.getter(VirtualGatewayConnectionPool::grpc)).setter(VirtualGatewayConnectionPool.setter(Builder::grpc)).constructor(VirtualGatewayGrpcConnectionPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpc").build()}).build();
    private static final SdkField<VirtualGatewayHttpConnectionPool> HTTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("http").getter(VirtualGatewayConnectionPool.getter(VirtualGatewayConnectionPool::http)).setter(VirtualGatewayConnectionPool.setter(Builder::http)).constructor(VirtualGatewayHttpConnectionPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http").build()}).build();
    private static final SdkField<VirtualGatewayHttp2ConnectionPool> HTTP2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("http2").getter(VirtualGatewayConnectionPool.getter(VirtualGatewayConnectionPool::http2)).setter(VirtualGatewayConnectionPool.setter(Builder::http2)).constructor(VirtualGatewayHttp2ConnectionPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_FIELD, HTTP_FIELD, HTTP2_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("grpc", GRPC_FIELD);
            this.put("http", HTTP_FIELD);
            this.put("http2", HTTP2_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VirtualGatewayGrpcConnectionPool grpc;
    private final VirtualGatewayHttpConnectionPool http;
    private final VirtualGatewayHttp2ConnectionPool http2;
    private final Type type;

    private VirtualGatewayConnectionPool(BuilderImpl builder) {
        this.grpc = builder.grpc;
        this.http = builder.http;
        this.http2 = builder.http2;
        this.type = builder.type;
    }

    public final VirtualGatewayGrpcConnectionPool grpc() {
        return this.grpc;
    }

    public final VirtualGatewayHttpConnectionPool http() {
        return this.http;
    }

    public final VirtualGatewayHttp2ConnectionPool http2() {
        return this.http2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.http());
        hashCode = 31 * hashCode + Objects.hashCode(this.http2());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayConnectionPool)) {
            return false;
        }
        VirtualGatewayConnectionPool other = (VirtualGatewayConnectionPool)obj;
        return Objects.equals(this.grpc(), other.grpc()) && Objects.equals(this.http(), other.http()) && Objects.equals(this.http2(), other.http2());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualGatewayConnectionPool").add("Grpc", (Object)this.grpc()).add("Http", (Object)this.http()).add("Http2", (Object)this.http2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grpc": {
                return Optional.ofNullable(clazz.cast(this.grpc()));
            }
            case "http": {
                return Optional.ofNullable(clazz.cast(this.http()));
            }
            case "http2": {
                return Optional.ofNullable(clazz.cast(this.http2()));
            }
        }
        return Optional.empty();
    }

    public static VirtualGatewayConnectionPool fromGrpc(VirtualGatewayGrpcConnectionPool grpc) {
        return (VirtualGatewayConnectionPool)VirtualGatewayConnectionPool.builder().grpc(grpc).build();
    }

    public static VirtualGatewayConnectionPool fromGrpc(Consumer<VirtualGatewayGrpcConnectionPool.Builder> grpc) {
        VirtualGatewayGrpcConnectionPool.Builder builder = VirtualGatewayGrpcConnectionPool.builder();
        grpc.accept(builder);
        return VirtualGatewayConnectionPool.fromGrpc((VirtualGatewayGrpcConnectionPool)builder.build());
    }

    public static VirtualGatewayConnectionPool fromHttp(VirtualGatewayHttpConnectionPool http) {
        return (VirtualGatewayConnectionPool)VirtualGatewayConnectionPool.builder().http(http).build();
    }

    public static VirtualGatewayConnectionPool fromHttp(Consumer<VirtualGatewayHttpConnectionPool.Builder> http) {
        VirtualGatewayHttpConnectionPool.Builder builder = VirtualGatewayHttpConnectionPool.builder();
        http.accept(builder);
        return VirtualGatewayConnectionPool.fromHttp((VirtualGatewayHttpConnectionPool)builder.build());
    }

    public static VirtualGatewayConnectionPool fromHttp2(VirtualGatewayHttp2ConnectionPool http2) {
        return (VirtualGatewayConnectionPool)VirtualGatewayConnectionPool.builder().http2(http2).build();
    }

    public static VirtualGatewayConnectionPool fromHttp2(Consumer<VirtualGatewayHttp2ConnectionPool.Builder> http2) {
        VirtualGatewayHttp2ConnectionPool.Builder builder = VirtualGatewayHttp2ConnectionPool.builder();
        http2.accept(builder);
        return VirtualGatewayConnectionPool.fromHttp2((VirtualGatewayHttp2ConnectionPool)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayConnectionPool, T> g) {
        return obj -> g.apply((VirtualGatewayConnectionPool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GRPC,
        HTTP,
        HTTP2,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VirtualGatewayGrpcConnectionPool grpc;
        private VirtualGatewayHttpConnectionPool http;
        private VirtualGatewayHttp2ConnectionPool http2;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayConnectionPool model) {
            this.grpc(model.grpc);
            this.http(model.http);
            this.http2(model.http2);
        }

        public final VirtualGatewayGrpcConnectionPool.Builder getGrpc() {
            return this.grpc != null ? this.grpc.toBuilder() : null;
        }

        public final void setGrpc(VirtualGatewayGrpcConnectionPool.BuilderImpl grpc) {
            VirtualGatewayGrpcConnectionPool oldValue = this.grpc;
            this.grpc = grpc != null ? grpc.build() : null;
            this.handleUnionValueChange(Type.GRPC, oldValue, this.grpc);
        }

        @Override
        public final Builder grpc(VirtualGatewayGrpcConnectionPool grpc) {
            VirtualGatewayGrpcConnectionPool oldValue = this.grpc;
            this.grpc = grpc;
            this.handleUnionValueChange(Type.GRPC, oldValue, this.grpc);
            return this;
        }

        public final VirtualGatewayHttpConnectionPool.Builder getHttp() {
            return this.http != null ? this.http.toBuilder() : null;
        }

        public final void setHttp(VirtualGatewayHttpConnectionPool.BuilderImpl http) {
            VirtualGatewayHttpConnectionPool oldValue = this.http;
            this.http = http != null ? http.build() : null;
            this.handleUnionValueChange(Type.HTTP, oldValue, this.http);
        }

        @Override
        public final Builder http(VirtualGatewayHttpConnectionPool http) {
            VirtualGatewayHttpConnectionPool oldValue = this.http;
            this.http = http;
            this.handleUnionValueChange(Type.HTTP, oldValue, this.http);
            return this;
        }

        public final VirtualGatewayHttp2ConnectionPool.Builder getHttp2() {
            return this.http2 != null ? this.http2.toBuilder() : null;
        }

        public final void setHttp2(VirtualGatewayHttp2ConnectionPool.BuilderImpl http2) {
            VirtualGatewayHttp2ConnectionPool oldValue = this.http2;
            this.http2 = http2 != null ? http2.build() : null;
            this.handleUnionValueChange(Type.HTTP2, oldValue, this.http2);
        }

        @Override
        public final Builder http2(VirtualGatewayHttp2ConnectionPool http2) {
            VirtualGatewayHttp2ConnectionPool oldValue = this.http2;
            this.http2 = http2;
            this.handleUnionValueChange(Type.HTTP2, oldValue, this.http2);
            return this;
        }

        public VirtualGatewayConnectionPool build() {
            return new VirtualGatewayConnectionPool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewayConnectionPool> {
        public Builder grpc(VirtualGatewayGrpcConnectionPool var1);

        default public Builder grpc(Consumer<VirtualGatewayGrpcConnectionPool.Builder> grpc) {
            return this.grpc((VirtualGatewayGrpcConnectionPool)((VirtualGatewayGrpcConnectionPool.Builder)VirtualGatewayGrpcConnectionPool.builder().applyMutation(grpc)).build());
        }

        public Builder http(VirtualGatewayHttpConnectionPool var1);

        default public Builder http(Consumer<VirtualGatewayHttpConnectionPool.Builder> http) {
            return this.http((VirtualGatewayHttpConnectionPool)((VirtualGatewayHttpConnectionPool.Builder)VirtualGatewayHttpConnectionPool.builder().applyMutation(http)).build());
        }

        public Builder http2(VirtualGatewayHttp2ConnectionPool var1);

        default public Builder http2(Consumer<VirtualGatewayHttp2ConnectionPool.Builder> http2) {
            return this.http2((VirtualGatewayHttp2ConnectionPool)((VirtualGatewayHttp2ConnectionPool.Builder)VirtualGatewayHttp2ConnectionPool.builder().applyMutation(http2)).build());
        }
    }
}

