/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.ResourceMetadata;
import software.amazon.awssdk.services.appmesh.model.RouteSpec;
import software.amazon.awssdk.services.appmesh.model.RouteStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(RouteData.getter(RouteData::meshName)).setter(RouteData.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(RouteData.getter(RouteData::metadata)).setter(RouteData.setter(Builder::metadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> ROUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("routeName").getter(RouteData.getter(RouteData::routeName)).setter(RouteData.setter(Builder::routeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeName").build()}).build();
    private static final SdkField<RouteSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(RouteData.getter(RouteData::spec)).setter(RouteData.setter(Builder::spec)).constructor(RouteSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<RouteStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(RouteData.getter(RouteData::status)).setter(RouteData.setter(Builder::status)).constructor(RouteStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualRouterName").getter(RouteData.getter(RouteData::virtualRouterName)).setter(RouteData.setter(Builder::virtualRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, METADATA_FIELD, ROUTE_NAME_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_ROUTER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("meshName", MESH_NAME_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("routeName", ROUTE_NAME_FIELD);
            this.put("spec", SPEC_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("virtualRouterName", VIRTUAL_ROUTER_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String meshName;
    private final ResourceMetadata metadata;
    private final String routeName;
    private final RouteSpec spec;
    private final RouteStatus status;
    private final String virtualRouterName;

    private RouteData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.routeName = builder.routeName;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualRouterName = builder.virtualRouterName;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final ResourceMetadata metadata() {
        return this.metadata;
    }

    public final String routeName() {
        return this.routeName;
    }

    public final RouteSpec spec() {
        return this.spec;
    }

    public final RouteStatus status() {
        return this.status;
    }

    public final String virtualRouterName() {
        return this.virtualRouterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteData)) {
            return false;
        }
        RouteData other = (RouteData)obj;
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.routeName(), other.routeName()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.virtualRouterName(), other.virtualRouterName());
    }

    public final String toString() {
        return ToString.builder((String)"RouteData").add("MeshName", (Object)this.meshName()).add("Metadata", (Object)this.metadata()).add("RouteName", (Object)this.routeName()).add("Spec", (Object)this.spec()).add("Status", (Object)this.status()).add("VirtualRouterName", (Object)this.virtualRouterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "routeName": {
                return Optional.ofNullable(clazz.cast(this.routeName()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "virtualRouterName": {
                return Optional.ofNullable(clazz.cast(this.virtualRouterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RouteData, T> g) {
        return obj -> g.apply((RouteData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meshName;
        private ResourceMetadata metadata;
        private String routeName;
        private RouteSpec spec;
        private RouteStatus status;
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteData model) {
            this.meshName(model.meshName);
            this.metadata(model.metadata);
            this.routeName(model.routeName);
            this.spec(model.spec);
            this.status(model.status);
            this.virtualRouterName(model.virtualRouterName);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getRouteName() {
            return this.routeName;
        }

        public final void setRouteName(String routeName) {
            this.routeName = routeName;
        }

        @Override
        public final Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public final RouteSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        public final void setSpec(RouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(RouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final RouteStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(RouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(RouteStatus status) {
            this.status = status;
            return this;
        }

        public final String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public RouteData build() {
            return new RouteData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteData> {
        public Builder meshName(String var1);

        public Builder metadata(ResourceMetadata var1);

        default public Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return this.metadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder routeName(String var1);

        public Builder spec(RouteSpec var1);

        default public Builder spec(Consumer<RouteSpec.Builder> spec) {
            return this.spec((RouteSpec)((RouteSpec.Builder)RouteSpec.builder().applyMutation(spec)).build());
        }

        public Builder status(RouteStatus var1);

        default public Builder status(Consumer<RouteStatus.Builder> status) {
            return this.status((RouteStatus)((RouteStatus.Builder)RouteStatus.builder().applyMutation(status)).build());
        }

        public Builder virtualRouterName(String var1);
    }
}

