/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeListCopier;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualNodesResponse
extends AppMeshResponse
implements ToCopyableBuilder<Builder, ListVirtualNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVirtualNodesResponse.getter(ListVirtualNodesResponse::nextToken)).setter(ListVirtualNodesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VirtualNodeRef>> VIRTUAL_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("virtualNodes").getter(ListVirtualNodesResponse.getter(ListVirtualNodesResponse::virtualNodes)).setter(ListVirtualNodesResponse.setter(Builder::virtualNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualNodeRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VIRTUAL_NODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("virtualNodes", VIRTUAL_NODES_FIELD);
        }
    });
    private final String nextToken;
    private final List<VirtualNodeRef> virtualNodes;

    private ListVirtualNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualNodes = builder.virtualNodes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVirtualNodes() {
        return this.virtualNodes != null && !(this.virtualNodes instanceof SdkAutoConstructList);
    }

    public final List<VirtualNodeRef> virtualNodes() {
        return this.virtualNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualNodes() ? this.virtualNodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualNodesResponse)) {
            return false;
        }
        ListVirtualNodesResponse other = (ListVirtualNodesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVirtualNodes() == other.hasVirtualNodes() && Objects.equals(this.virtualNodes(), other.virtualNodes());
    }

    public final String toString() {
        return ToString.builder((String)"ListVirtualNodesResponse").add("NextToken", (Object)this.nextToken()).add("VirtualNodes", this.hasVirtualNodes() ? this.virtualNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "virtualNodes": {
                return Optional.ofNullable(clazz.cast(this.virtualNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualNodesResponse, T> g) {
        return obj -> g.apply((ListVirtualNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VirtualNodeRef> virtualNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualNodesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.virtualNodes(model.virtualNodes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VirtualNodeRef.Builder> getVirtualNodes() {
            List<VirtualNodeRef.Builder> result = VirtualNodeListCopier.copyToBuilder(this.virtualNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualNodes(Collection<VirtualNodeRef.BuilderImpl> virtualNodes) {
            this.virtualNodes = VirtualNodeListCopier.copyFromBuilder(virtualNodes);
        }

        @Override
        public final Builder virtualNodes(Collection<VirtualNodeRef> virtualNodes) {
            this.virtualNodes = VirtualNodeListCopier.copy(virtualNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualNodes(VirtualNodeRef ... virtualNodes) {
            this.virtualNodes(Arrays.asList(virtualNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualNodes(Consumer<VirtualNodeRef.Builder> ... virtualNodes) {
            this.virtualNodes(Stream.of(virtualNodes).map(c -> (VirtualNodeRef)((VirtualNodeRef.Builder)VirtualNodeRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVirtualNodesResponse build() {
            return new ListVirtualNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppMeshResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualNodesResponse> {
        public Builder nextToken(String var1);

        public Builder virtualNodes(Collection<VirtualNodeRef> var1);

        public Builder virtualNodes(VirtualNodeRef ... var1);

        public Builder virtualNodes(Consumer<VirtualNodeRef.Builder> ... var1);
    }
}

