/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteSpec;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteStatus;
import software.amazon.awssdk.services.appmesh.model.ResourceMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayRouteData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayRouteData> {
    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayRouteName").getter(GatewayRouteData.getter(GatewayRouteData::gatewayRouteName)).setter(GatewayRouteData.setter(Builder::gatewayRouteName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRouteName").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(GatewayRouteData.getter(GatewayRouteData::meshName)).setter(GatewayRouteData.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GatewayRouteData.getter(GatewayRouteData::metadata)).setter(GatewayRouteData.setter(Builder::metadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<GatewayRouteSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(GatewayRouteData.getter(GatewayRouteData::spec)).setter(GatewayRouteData.setter(Builder::spec)).constructor(GatewayRouteSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<GatewayRouteStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GatewayRouteData.getter(GatewayRouteData::status)).setter(GatewayRouteData.setter(Builder::status)).constructor(GatewayRouteStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayName").getter(GatewayRouteData.getter(GatewayRouteData::virtualGatewayName)).setter(GatewayRouteData.setter(Builder::virtualGatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTE_NAME_FIELD, MESH_NAME_FIELD, METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("gatewayRouteName", GATEWAY_ROUTE_NAME_FIELD);
            this.put("meshName", MESH_NAME_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("spec", SPEC_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("virtualGatewayName", VIRTUAL_GATEWAY_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String gatewayRouteName;
    private final String meshName;
    private final ResourceMetadata metadata;
    private final GatewayRouteSpec spec;
    private final GatewayRouteStatus status;
    private final String virtualGatewayName;

    private GatewayRouteData(BuilderImpl builder) {
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    public final String gatewayRouteName() {
        return this.gatewayRouteName;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final ResourceMetadata metadata() {
        return this.metadata;
    }

    public final GatewayRouteSpec spec() {
        return this.spec;
    }

    public final GatewayRouteStatus status() {
        return this.status;
    }

    public final String virtualGatewayName() {
        return this.virtualGatewayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayRouteData)) {
            return false;
        }
        GatewayRouteData other = (GatewayRouteData)obj;
        return Objects.equals(this.gatewayRouteName(), other.gatewayRouteName()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.virtualGatewayName(), other.virtualGatewayName());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayRouteData").add("GatewayRouteName", (Object)this.gatewayRouteName()).add("MeshName", (Object)this.meshName()).add("Metadata", (Object)this.metadata()).add("Spec", (Object)this.spec()).add("Status", (Object)this.status()).add("VirtualGatewayName", (Object)this.virtualGatewayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayRouteName": {
                return Optional.ofNullable(clazz.cast(this.gatewayRouteName()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "virtualGatewayName": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GatewayRouteData, T> g) {
        return obj -> g.apply((GatewayRouteData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayRouteName;
        private String meshName;
        private ResourceMetadata metadata;
        private GatewayRouteSpec spec;
        private GatewayRouteStatus status;
        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayRouteData model) {
            this.gatewayRouteName(model.gatewayRouteName);
            this.meshName(model.meshName);
            this.metadata(model.metadata);
            this.spec(model.spec);
            this.status(model.status);
            this.virtualGatewayName(model.virtualGatewayName);
        }

        public final String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final GatewayRouteSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        public final void setSpec(GatewayRouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(GatewayRouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final GatewayRouteStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(GatewayRouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(GatewayRouteStatus status) {
            this.status = status;
            return this;
        }

        public final String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        public GatewayRouteData build() {
            return new GatewayRouteData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayRouteData> {
        public Builder gatewayRouteName(String var1);

        public Builder meshName(String var1);

        public Builder metadata(ResourceMetadata var1);

        default public Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return this.metadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder spec(GatewayRouteSpec var1);

        default public Builder spec(Consumer<GatewayRouteSpec.Builder> spec) {
            return this.spec((GatewayRouteSpec)((GatewayRouteSpec.Builder)GatewayRouteSpec.builder().applyMutation(spec)).build());
        }

        public Builder status(GatewayRouteStatus var1);

        default public Builder status(Consumer<GatewayRouteStatus.Builder> status) {
            return this.status((GatewayRouteStatus)((GatewayRouteStatus.Builder)GatewayRouteStatus.builder().applyMutation(status)).build());
        }

        public Builder virtualGatewayName(String var1);
    }
}

