/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewayClientTlsCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewayClientTlsCertificate> {
    private static final SdkField<VirtualGatewayListenerTlsFileCertificate> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(VirtualGatewayClientTlsCertificate.getter(VirtualGatewayClientTlsCertificate::file)).setter(VirtualGatewayClientTlsCertificate.setter(Builder::file)).constructor(VirtualGatewayListenerTlsFileCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<VirtualGatewayListenerTlsSdsCertificate> SDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sds").getter(VirtualGatewayClientTlsCertificate.getter(VirtualGatewayClientTlsCertificate::sds)).setter(VirtualGatewayClientTlsCertificate.setter(Builder::sds)).constructor(VirtualGatewayListenerTlsSdsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, SDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("file", FILE_FIELD);
            this.put("sds", SDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VirtualGatewayListenerTlsFileCertificate file;
    private final VirtualGatewayListenerTlsSdsCertificate sds;
    private final Type type;

    private VirtualGatewayClientTlsCertificate(BuilderImpl builder) {
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    public final VirtualGatewayListenerTlsFileCertificate file() {
        return this.file;
    }

    public final VirtualGatewayListenerTlsSdsCertificate sds() {
        return this.sds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayClientTlsCertificate)) {
            return false;
        }
        VirtualGatewayClientTlsCertificate other = (VirtualGatewayClientTlsCertificate)obj;
        return Objects.equals(this.file(), other.file()) && Objects.equals(this.sds(), other.sds());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualGatewayClientTlsCertificate").add("File", (Object)this.file()).add("Sds", (Object)this.sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sds": {
                return Optional.ofNullable(clazz.cast(this.sds()));
            }
        }
        return Optional.empty();
    }

    public static VirtualGatewayClientTlsCertificate fromFile(VirtualGatewayListenerTlsFileCertificate file) {
        return (VirtualGatewayClientTlsCertificate)VirtualGatewayClientTlsCertificate.builder().file(file).build();
    }

    public static VirtualGatewayClientTlsCertificate fromFile(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
        VirtualGatewayListenerTlsFileCertificate.Builder builder = VirtualGatewayListenerTlsFileCertificate.builder();
        file.accept(builder);
        return VirtualGatewayClientTlsCertificate.fromFile((VirtualGatewayListenerTlsFileCertificate)builder.build());
    }

    public static VirtualGatewayClientTlsCertificate fromSds(VirtualGatewayListenerTlsSdsCertificate sds) {
        return (VirtualGatewayClientTlsCertificate)VirtualGatewayClientTlsCertificate.builder().sds(sds).build();
    }

    public static VirtualGatewayClientTlsCertificate fromSds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
        VirtualGatewayListenerTlsSdsCertificate.Builder builder = VirtualGatewayListenerTlsSdsCertificate.builder();
        sds.accept(builder);
        return VirtualGatewayClientTlsCertificate.fromSds((VirtualGatewayListenerTlsSdsCertificate)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayClientTlsCertificate, T> g) {
        return obj -> g.apply((VirtualGatewayClientTlsCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE,
        SDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VirtualGatewayListenerTlsFileCertificate file;
        private VirtualGatewayListenerTlsSdsCertificate sds;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayClientTlsCertificate model) {
            this.file(model.file);
            this.sds(model.sds);
        }

        public final VirtualGatewayListenerTlsFileCertificate.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(VirtualGatewayListenerTlsFileCertificate.BuilderImpl file) {
            VirtualGatewayListenerTlsFileCertificate oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(VirtualGatewayListenerTlsFileCertificate file) {
            VirtualGatewayListenerTlsFileCertificate oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final VirtualGatewayListenerTlsSdsCertificate.Builder getSds() {
            return this.sds != null ? this.sds.toBuilder() : null;
        }

        public final void setSds(VirtualGatewayListenerTlsSdsCertificate.BuilderImpl sds) {
            VirtualGatewayListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        public final Builder sds(VirtualGatewayListenerTlsSdsCertificate sds) {
            VirtualGatewayListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        public VirtualGatewayClientTlsCertificate build() {
            return new VirtualGatewayClientTlsCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewayClientTlsCertificate> {
        public Builder file(VirtualGatewayListenerTlsFileCertificate var1);

        default public Builder file(Consumer<VirtualGatewayListenerTlsFileCertificate.Builder> file) {
            return this.file((VirtualGatewayListenerTlsFileCertificate)((VirtualGatewayListenerTlsFileCertificate.Builder)VirtualGatewayListenerTlsFileCertificate.builder().applyMutation(file)).build());
        }

        public Builder sds(VirtualGatewayListenerTlsSdsCertificate var1);

        default public Builder sds(Consumer<VirtualGatewayListenerTlsSdsCertificate.Builder> sds) {
            return this.sds((VirtualGatewayListenerTlsSdsCertificate)((VirtualGatewayListenerTlsSdsCertificate.Builder)VirtualGatewayListenerTlsSdsCertificate.builder().applyMutation(sds)).build());
        }
    }
}

