/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.Backend;
import software.amazon.awssdk.services.appmesh.model.BackendDefaults;
import software.amazon.awssdk.services.appmesh.model.BackendsCopier;
import software.amazon.awssdk.services.appmesh.model.Listener;
import software.amazon.awssdk.services.appmesh.model.ListenersCopier;
import software.amazon.awssdk.services.appmesh.model.Logging;
import software.amazon.awssdk.services.appmesh.model.ServiceDiscovery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualNodeSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualNodeSpec> {
    private static final SdkField<BackendDefaults> BACKEND_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("backendDefaults").getter(VirtualNodeSpec.getter(VirtualNodeSpec::backendDefaults)).setter(VirtualNodeSpec.setter(Builder::backendDefaults)).constructor(BackendDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendDefaults").build()}).build();
    private static final SdkField<List<Backend>> BACKENDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("backends").getter(VirtualNodeSpec.getter(VirtualNodeSpec::backends)).setter(VirtualNodeSpec.setter(Builder::backends)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backends").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Backend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listeners").getter(VirtualNodeSpec.getter(VirtualNodeSpec::listeners)).setter(VirtualNodeSpec.setter(Builder::listeners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Listener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(VirtualNodeSpec.getter(VirtualNodeSpec::logging)).setter(VirtualNodeSpec.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<ServiceDiscovery> SERVICE_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceDiscovery").getter(VirtualNodeSpec.getter(VirtualNodeSpec::serviceDiscovery)).setter(VirtualNodeSpec.setter(Builder::serviceDiscovery)).constructor(ServiceDiscovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDiscovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_DEFAULTS_FIELD, BACKENDS_FIELD, LISTENERS_FIELD, LOGGING_FIELD, SERVICE_DISCOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("backendDefaults", BACKEND_DEFAULTS_FIELD);
            this.put("backends", BACKENDS_FIELD);
            this.put("listeners", LISTENERS_FIELD);
            this.put("logging", LOGGING_FIELD);
            this.put("serviceDiscovery", SERVICE_DISCOVERY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BackendDefaults backendDefaults;
    private final List<Backend> backends;
    private final List<Listener> listeners;
    private final Logging logging;
    private final ServiceDiscovery serviceDiscovery;

    private VirtualNodeSpec(BuilderImpl builder) {
        this.backendDefaults = builder.backendDefaults;
        this.backends = builder.backends;
        this.listeners = builder.listeners;
        this.logging = builder.logging;
        this.serviceDiscovery = builder.serviceDiscovery;
    }

    public final BackendDefaults backendDefaults() {
        return this.backendDefaults;
    }

    public final boolean hasBackends() {
        return this.backends != null && !(this.backends instanceof SdkAutoConstructList);
    }

    public final List<Backend> backends() {
        return this.backends;
    }

    public final boolean hasListeners() {
        return this.listeners != null && !(this.listeners instanceof SdkAutoConstructList);
    }

    public final List<Listener> listeners() {
        return this.listeners;
    }

    public final Logging logging() {
        return this.logging;
    }

    public final ServiceDiscovery serviceDiscovery() {
        return this.serviceDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backendDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackends() ? this.backends() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListeners() ? this.listeners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDiscovery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeSpec)) {
            return false;
        }
        VirtualNodeSpec other = (VirtualNodeSpec)obj;
        return Objects.equals(this.backendDefaults(), other.backendDefaults()) && this.hasBackends() == other.hasBackends() && Objects.equals(this.backends(), other.backends()) && this.hasListeners() == other.hasListeners() && Objects.equals(this.listeners(), other.listeners()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.serviceDiscovery(), other.serviceDiscovery());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualNodeSpec").add("BackendDefaults", (Object)this.backendDefaults()).add("Backends", this.hasBackends() ? this.backends() : null).add("Listeners", this.hasListeners() ? this.listeners() : null).add("Logging", (Object)this.logging()).add("ServiceDiscovery", (Object)this.serviceDiscovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "backendDefaults": {
                return Optional.ofNullable(clazz.cast(this.backendDefaults()));
            }
            case "backends": {
                return Optional.ofNullable(clazz.cast(this.backends()));
            }
            case "listeners": {
                return Optional.ofNullable(clazz.cast(this.listeners()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "serviceDiscovery": {
                return Optional.ofNullable(clazz.cast(this.serviceDiscovery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeSpec, T> g) {
        return obj -> g.apply((VirtualNodeSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BackendDefaults backendDefaults;
        private List<Backend> backends = DefaultSdkAutoConstructList.getInstance();
        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();
        private Logging logging;
        private ServiceDiscovery serviceDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeSpec model) {
            this.backendDefaults(model.backendDefaults);
            this.backends(model.backends);
            this.listeners(model.listeners);
            this.logging(model.logging);
            this.serviceDiscovery(model.serviceDiscovery);
        }

        public final BackendDefaults.Builder getBackendDefaults() {
            return this.backendDefaults != null ? this.backendDefaults.toBuilder() : null;
        }

        public final void setBackendDefaults(BackendDefaults.BuilderImpl backendDefaults) {
            this.backendDefaults = backendDefaults != null ? backendDefaults.build() : null;
        }

        @Override
        public final Builder backendDefaults(BackendDefaults backendDefaults) {
            this.backendDefaults = backendDefaults;
            return this;
        }

        public final List<Backend.Builder> getBackends() {
            List<Backend.Builder> result = BackendsCopier.copyToBuilder(this.backends);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackends(Collection<Backend.BuilderImpl> backends) {
            this.backends = BackendsCopier.copyFromBuilder(backends);
        }

        @Override
        public final Builder backends(Collection<Backend> backends) {
            this.backends = BackendsCopier.copy(backends);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backends(Backend ... backends) {
            this.backends(Arrays.asList(backends));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backends(Consumer<Backend.Builder> ... backends) {
            this.backends(Stream.of(backends).map(c -> (Backend)((Backend.Builder)Backend.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Listener.Builder> getListeners() {
            List<Listener.Builder> result = ListenersCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (Listener)((Listener.Builder)Listener.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final ServiceDiscovery.Builder getServiceDiscovery() {
            return this.serviceDiscovery != null ? this.serviceDiscovery.toBuilder() : null;
        }

        public final void setServiceDiscovery(ServiceDiscovery.BuilderImpl serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery != null ? serviceDiscovery.build() : null;
        }

        @Override
        public final Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public VirtualNodeSpec build() {
            return new VirtualNodeSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualNodeSpec> {
        public Builder backendDefaults(BackendDefaults var1);

        default public Builder backendDefaults(Consumer<BackendDefaults.Builder> backendDefaults) {
            return this.backendDefaults((BackendDefaults)((BackendDefaults.Builder)BackendDefaults.builder().applyMutation(backendDefaults)).build());
        }

        public Builder backends(Collection<Backend> var1);

        public Builder backends(Backend ... var1);

        public Builder backends(Consumer<Backend.Builder> ... var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);

        public Builder listeners(Consumer<Listener.Builder> ... var1);

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder serviceDiscovery(ServiceDiscovery var1);

        default public Builder serviceDiscovery(Consumer<ServiceDiscovery.Builder> serviceDiscovery) {
            return this.serviceDiscovery((ServiceDiscovery)((ServiceDiscovery.Builder)ServiceDiscovery.builder().applyMutation(serviceDiscovery)).build());
        }
    }
}

