/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.PortProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortMapping> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(PortMapping.getter(PortMapping::port)).setter(PortMapping.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(PortMapping.getter(PortMapping::protocolAsString)).setter(PortMapping.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("port", PORT_FIELD);
            this.put("protocol", PROTOCOL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final String protocol;

    private PortMapping(BuilderImpl builder) {
        this.port = builder.port;
        this.protocol = builder.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final PortProtocol protocol() {
        return PortProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PortMapping").add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PortMapping, T> g) {
        return obj -> g.apply((PortMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(PortMapping model) {
            this.port(model.port);
            this.protocol(model.protocol);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(PortProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public PortMapping build() {
            return new PortMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortMapping> {
        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(PortProtocol var1);
    }
}

