/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.ResourceMetadata;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualRouterData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualRouterData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(VirtualRouterData.getter(VirtualRouterData::meshName)).setter(VirtualRouterData.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(VirtualRouterData.getter(VirtualRouterData::metadata)).setter(VirtualRouterData.setter(Builder::metadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<VirtualRouterSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(VirtualRouterData.getter(VirtualRouterData::spec)).setter(VirtualRouterData.setter(Builder::spec)).constructor(VirtualRouterSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<VirtualRouterStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(VirtualRouterData.getter(VirtualRouterData::status)).setter(VirtualRouterData.setter(Builder::status)).constructor(VirtualRouterStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualRouterName").getter(VirtualRouterData.getter(VirtualRouterData::virtualRouterName)).setter(VirtualRouterData.setter(Builder::virtualRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_ROUTER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("meshName", MESH_NAME_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("spec", SPEC_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("virtualRouterName", VIRTUAL_ROUTER_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String meshName;
    private final ResourceMetadata metadata;
    private final VirtualRouterSpec spec;
    private final VirtualRouterStatus status;
    private final String virtualRouterName;

    private VirtualRouterData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualRouterName = builder.virtualRouterName;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final ResourceMetadata metadata() {
        return this.metadata;
    }

    public final VirtualRouterSpec spec() {
        return this.spec;
    }

    public final VirtualRouterStatus status() {
        return this.status;
    }

    public final String virtualRouterName() {
        return this.virtualRouterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterData)) {
            return false;
        }
        VirtualRouterData other = (VirtualRouterData)obj;
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.virtualRouterName(), other.virtualRouterName());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualRouterData").add("MeshName", (Object)this.meshName()).add("Metadata", (Object)this.metadata()).add("Spec", (Object)this.spec()).add("Status", (Object)this.status()).add("VirtualRouterName", (Object)this.virtualRouterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "virtualRouterName": {
                return Optional.ofNullable(clazz.cast(this.virtualRouterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterData, T> g) {
        return obj -> g.apply((VirtualRouterData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meshName;
        private ResourceMetadata metadata;
        private VirtualRouterSpec spec;
        private VirtualRouterStatus status;
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterData model) {
            this.meshName(model.meshName);
            this.metadata(model.metadata);
            this.spec(model.spec);
            this.status(model.status);
            this.virtualRouterName(model.virtualRouterName);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final VirtualRouterSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        public final void setSpec(VirtualRouterSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(VirtualRouterSpec spec) {
            this.spec = spec;
            return this;
        }

        public final VirtualRouterStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(VirtualRouterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(VirtualRouterStatus status) {
            this.status = status;
            return this;
        }

        public final String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public VirtualRouterData build() {
            return new VirtualRouterData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualRouterData> {
        public Builder meshName(String var1);

        public Builder metadata(ResourceMetadata var1);

        default public Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return this.metadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder spec(VirtualRouterSpec var1);

        default public Builder spec(Consumer<VirtualRouterSpec.Builder> spec) {
            return this.spec((VirtualRouterSpec)((VirtualRouterSpec.Builder)VirtualRouterSpec.builder().applyMutation(spec)).build());
        }

        public Builder status(VirtualRouterStatus var1);

        default public Builder status(Consumer<VirtualRouterStatus.Builder> status) {
            return this.status((VirtualRouterStatus)((VirtualRouterStatus.Builder)VirtualRouterStatus.builder().applyMutation(status)).build());
        }

        public Builder virtualRouterName(String var1);
    }
}

