/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.PortSetCopier;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientTlsCertificate;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewayClientPolicyTls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewayClientPolicyTls> {
    private static final SdkField<VirtualGatewayClientTlsCertificate> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificate").getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::certificate)).setter(VirtualGatewayClientPolicyTls.setter(Builder::certificate)).constructor(VirtualGatewayClientTlsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<Boolean> ENFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enforce").getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::enforce)).setter(VirtualGatewayClientPolicyTls.setter(Builder::enforce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enforce").build()}).build();
    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ports").getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::ports)).setter(VirtualGatewayClientPolicyTls.setter(Builder::ports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VirtualGatewayTlsValidationContext> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validation").getter(VirtualGatewayClientPolicyTls.getter(VirtualGatewayClientPolicyTls::validation)).setter(VirtualGatewayClientPolicyTls.setter(Builder::validation)).constructor(VirtualGatewayTlsValidationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, ENFORCE_FIELD, PORTS_FIELD, VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificate", CERTIFICATE_FIELD);
            this.put("enforce", ENFORCE_FIELD);
            this.put("ports", PORTS_FIELD);
            this.put("validation", VALIDATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VirtualGatewayClientTlsCertificate certificate;
    private final Boolean enforce;
    private final List<Integer> ports;
    private final VirtualGatewayTlsValidationContext validation;

    private VirtualGatewayClientPolicyTls(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.enforce = builder.enforce;
        this.ports = builder.ports;
        this.validation = builder.validation;
    }

    public final VirtualGatewayClientTlsCertificate certificate() {
        return this.certificate;
    }

    public final Boolean enforce() {
        return this.enforce;
    }

    public final boolean hasPorts() {
        return this.ports != null && !(this.ports instanceof SdkAutoConstructList);
    }

    public final List<Integer> ports() {
        return this.ports;
    }

    public final VirtualGatewayTlsValidationContext validation() {
        return this.validation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPorts() ? this.ports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayClientPolicyTls)) {
            return false;
        }
        VirtualGatewayClientPolicyTls other = (VirtualGatewayClientPolicyTls)obj;
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.enforce(), other.enforce()) && this.hasPorts() == other.hasPorts() && Objects.equals(this.ports(), other.ports()) && Objects.equals(this.validation(), other.validation());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualGatewayClientPolicyTls").add("Certificate", (Object)this.certificate()).add("Enforce", (Object)this.enforce()).add("Ports", this.hasPorts() ? this.ports() : null).add("Validation", (Object)this.validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "enforce": {
                return Optional.ofNullable(clazz.cast(this.enforce()));
            }
            case "ports": {
                return Optional.ofNullable(clazz.cast(this.ports()));
            }
            case "validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayClientPolicyTls, T> g) {
        return obj -> g.apply((VirtualGatewayClientPolicyTls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VirtualGatewayClientTlsCertificate certificate;
        private Boolean enforce;
        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();
        private VirtualGatewayTlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayClientPolicyTls model) {
            this.certificate(model.certificate);
            this.enforce(model.enforce);
            this.ports(model.ports);
            this.validation(model.validation);
        }

        public final VirtualGatewayClientTlsCertificate.Builder getCertificate() {
            return this.certificate != null ? this.certificate.toBuilder() : null;
        }

        public final void setCertificate(VirtualGatewayClientTlsCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(VirtualGatewayClientTlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final Boolean getEnforce() {
            return this.enforce;
        }

        public final void setEnforce(Boolean enforce) {
            this.enforce = enforce;
        }

        @Override
        public final Builder enforce(Boolean enforce) {
            this.enforce = enforce;
            return this;
        }

        public final Collection<Integer> getPorts() {
            if (this.ports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ports;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        public final VirtualGatewayTlsValidationContext.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        public final void setValidation(VirtualGatewayTlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(VirtualGatewayTlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        public VirtualGatewayClientPolicyTls build() {
            return new VirtualGatewayClientPolicyTls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewayClientPolicyTls> {
        public Builder certificate(VirtualGatewayClientTlsCertificate var1);

        default public Builder certificate(Consumer<VirtualGatewayClientTlsCertificate.Builder> certificate) {
            return this.certificate((VirtualGatewayClientTlsCertificate)((VirtualGatewayClientTlsCertificate.Builder)VirtualGatewayClientTlsCertificate.builder().applyMutation(certificate)).build());
        }

        public Builder enforce(Boolean var1);

        public Builder ports(Collection<Integer> var1);

        public Builder ports(Integer ... var1);

        public Builder validation(VirtualGatewayTlsValidationContext var1);

        default public Builder validation(Consumer<VirtualGatewayTlsValidationContext.Builder> validation) {
            return this.validation((VirtualGatewayTlsValidationContext)((VirtualGatewayTlsValidationContext.Builder)VirtualGatewayTlsValidationContext.builder().applyMutation(validation)).build());
        }
    }
}

