/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.CreateMeshRequest;
import software.amazon.awssdk.services.appmesh.model.CreateMeshResponse;
import software.amazon.awssdk.services.appmesh.model.CreateRouteRequest;
import software.amazon.awssdk.services.appmesh.model.CreateRouteResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.ListMeshesRequest;
import software.amazon.awssdk.services.appmesh.model.ListMeshesResponse;
import software.amazon.awssdk.services.appmesh.model.ListRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse;
import software.amazon.awssdk.services.appmesh.model.TagResourceRequest;
import software.amazon.awssdk.services.appmesh.model.TagResourceResponse;
import software.amazon.awssdk.services.appmesh.model.UntagResourceRequest;
import software.amazon.awssdk.services.appmesh.model.UntagResourceResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateRouteRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.paginators.ListGatewayRoutesPublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListRoutesPublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualGatewaysPublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualNodesPublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualRoutersPublisher;
import software.amazon.awssdk.services.appmesh.paginators.ListVirtualServicesPublisher;

/**
 * Service client for accessing AWS App Mesh asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * App Mesh is a service mesh based on the Envoy proxy that makes it easy to monitor and control microservices. App Mesh
 * standardizes how your microservices communicate, giving you end-to-end visibility and helping to ensure high
 * availability for your applications.
 * </p>
 * <p>
 * App Mesh gives you consistent visibility and network traffic controls for every microservice in an application. You
 * can use App Mesh with Amazon Web Services Fargate, Amazon ECS, Amazon EKS, Kubernetes on Amazon Web Services, and
 * Amazon EC2.
 * </p>
 * <note>
 * <p>
 * App Mesh supports microservice applications that use service discovery naming for their components. For more
 * information about service discovery on Amazon ECS, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a> in
 * the <i>Amazon Elastic Container Service Developer Guide</i>. Kubernetes <code>kube-dns</code> and
 * <code>coredns</code> are supported. For more information, see <a
 * href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/">DNS for Services and Pods</a> in the
 * Kubernetes documentation.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppMeshAsyncClient extends AwsClient {
    String SERVICE_NAME = "appmesh";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appmesh";

    /**
     * <p>
     * Creates a gateway route.
     * </p>
     * <p>
     * A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route
     * matches a request, it can distribute traffic to a target virtual service.
     * </p>
     * <p>
     * For more information about gateway routes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes</a>.
     * </p>
     *
     * @param createGatewayRouteRequest
     * @return A Java Future containing the result of the CreateGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGatewayRouteResponse> createGatewayRoute(CreateGatewayRouteRequest createGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway route.
     * </p>
     * <p>
     * A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route
     * matches a request, it can distribute traffic to a target virtual service.
     * </p>
     * <p>
     * For more information about gateway routes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRouteRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGatewayRouteRequest#builder()}
     * </p>
     *
     * @param createGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGatewayRouteResponse> createGatewayRoute(
            Consumer<CreateGatewayRouteRequest.Builder> createGatewayRouteRequest) {
        return createGatewayRoute(CreateGatewayRouteRequest.builder().applyMutation(createGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Creates a service mesh.
     * </p>
     * <p>
     * A service mesh is a logical boundary for network traffic between services that are represented by resources
     * within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual
     * routers, and routes to distribute traffic between the applications in your mesh.
     * </p>
     * <p>
     * For more information about service meshes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes</a>.
     * </p>
     *
     * @param createMeshRequest
     * @return A Java Future containing the result of the CreateMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMeshResponse> createMesh(CreateMeshRequest createMeshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service mesh.
     * </p>
     * <p>
     * A service mesh is a logical boundary for network traffic between services that are represented by resources
     * within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual
     * routers, and routes to distribute traffic between the applications in your mesh.
     * </p>
     * <p>
     * For more information about service meshes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMeshRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMeshRequest#builder()}
     * </p>
     *
     * @param createMeshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateMeshRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMeshResponse> createMesh(Consumer<CreateMeshRequest.Builder> createMeshRequest) {
        return createMesh(CreateMeshRequest.builder().applyMutation(createMeshRequest).build());
    }

    /**
     * <p>
     * Creates a route that is associated with a virtual router.
     * </p>
     * <p>
     * You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or
     * more virtual nodes.
     * </p>
     * <p>
     * For more information about routes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a>.
     * </p>
     *
     * @param createRouteRequest
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRouteResponse> createRoute(CreateRouteRequest createRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route that is associated with a virtual router.
     * </p>
     * <p>
     * You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or
     * more virtual nodes.
     * </p>
     * <p>
     * For more information about routes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRouteRequest#builder()}
     * </p>
     *
     * @param createRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRouteResponse> createRoute(Consumer<CreateRouteRequest.Builder> createRouteRequest) {
        return createRoute(CreateRouteRequest.builder().applyMutation(createRouteRequest).build());
    }

    /**
     * <p>
     * Creates a virtual gateway.
     * </p>
     * <p>
     * A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The
     * virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon
     * EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway
     * represents Envoy deployed by itself.
     * </p>
     * <p>
     * For more information about virtual gateways, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways</a>.
     * </p>
     *
     * @param createVirtualGatewayRequest
     * @return A Java Future containing the result of the CreateVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualGatewayResponse> createVirtualGateway(
            CreateVirtualGatewayRequest createVirtualGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual gateway.
     * </p>
     * <p>
     * A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The
     * virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon
     * EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway
     * represents Envoy deployed by itself.
     * </p>
     * <p>
     * For more information about virtual gateways, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVirtualGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVirtualGatewayRequest#builder()}
     * </p>
     *
     * @param createVirtualGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualGatewayResponse> createVirtualGateway(
            Consumer<CreateVirtualGatewayRequest.Builder> createVirtualGatewayRequest) {
        return createVirtualGateway(CreateVirtualGatewayRequest.builder().applyMutation(createVirtualGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a virtual node within a service mesh.
     * </p>
     * <p>
     * A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a
     * Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your
     * task group, and whether the proxy running in a task group will communicate with other proxies using Transport
     * Layer Security (TLS).
     * </p>
     * <p>
     * You define a <code>listener</code> for any inbound traffic that your virtual node expects. Any virtual service
     * that your virtual node expects to communicate to is specified as a <code>backend</code>.
     * </p>
     * <p>
     * The response metadata for your new virtual node contains the <code>arn</code> that is associated with the virtual
     * node. Set this value to the full ARN; for example,
     * <code>arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp</code>) as the
     * <code>APPMESH_RESOURCE_ARN</code> environment variable for your task group's Envoy proxy container in your task
     * definition or pod spec. This is then mapped to the <code>node.id</code> and <code>node.cluster</code> Envoy
     * parameters.
     * </p>
     * <note>
     * <p>
     * By default, App Mesh uses the name of the resource you specified in <code>APPMESH_RESOURCE_ARN</code> when Envoy
     * is referring to itself in metrics and traces. You can override this behavior by setting the
     * <code>APPMESH_RESOURCE_CLUSTER</code> environment variable with your own name.
     * </p>
     * </note>
     * <p>
     * For more information about virtual nodes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a>. You must be
     * using <code>1.15.0</code> or later of the Envoy image when setting these variables. For more information aboutApp
     * Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy
     * image</a> in the App Mesh User Guide.
     * </p>
     *
     * @param createVirtualNodeRequest
     * @return A Java Future containing the result of the CreateVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVirtualNodeResponse> createVirtualNode(CreateVirtualNodeRequest createVirtualNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual node within a service mesh.
     * </p>
     * <p>
     * A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a
     * Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your
     * task group, and whether the proxy running in a task group will communicate with other proxies using Transport
     * Layer Security (TLS).
     * </p>
     * <p>
     * You define a <code>listener</code> for any inbound traffic that your virtual node expects. Any virtual service
     * that your virtual node expects to communicate to is specified as a <code>backend</code>.
     * </p>
     * <p>
     * The response metadata for your new virtual node contains the <code>arn</code> that is associated with the virtual
     * node. Set this value to the full ARN; for example,
     * <code>arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp</code>) as the
     * <code>APPMESH_RESOURCE_ARN</code> environment variable for your task group's Envoy proxy container in your task
     * definition or pod spec. This is then mapped to the <code>node.id</code> and <code>node.cluster</code> Envoy
     * parameters.
     * </p>
     * <note>
     * <p>
     * By default, App Mesh uses the name of the resource you specified in <code>APPMESH_RESOURCE_ARN</code> when Envoy
     * is referring to itself in metrics and traces. You can override this behavior by setting the
     * <code>APPMESH_RESOURCE_CLUSTER</code> environment variable with your own name.
     * </p>
     * </note>
     * <p>
     * For more information about virtual nodes, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a>. You must be
     * using <code>1.15.0</code> or later of the Envoy image when setting these variables. For more information aboutApp
     * Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy
     * image</a> in the App Mesh User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVirtualNodeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVirtualNodeRequest#builder()}
     * </p>
     *
     * @param createVirtualNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVirtualNodeResponse> createVirtualNode(
            Consumer<CreateVirtualNodeRequest.Builder> createVirtualNodeRequest) {
        return createVirtualNode(CreateVirtualNodeRequest.builder().applyMutation(createVirtualNodeRequest).build());
    }

    /**
     * <p>
     * Creates a virtual router within a service mesh.
     * </p>
     * <p>
     * Specify a <code>listener</code> for any inbound traffic that your virtual router receives. Create a virtual
     * router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual
     * services within your mesh. After you create your virtual router, create and associate routes for your virtual
     * router that direct incoming requests to different virtual nodes.
     * </p>
     * <p>
     * For more information about virtual routers, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers</a>.
     * </p>
     *
     * @param createVirtualRouterRequest
     * @return A Java Future containing the result of the CreateVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualRouterResponse> createVirtualRouter(
            CreateVirtualRouterRequest createVirtualRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual router within a service mesh.
     * </p>
     * <p>
     * Specify a <code>listener</code> for any inbound traffic that your virtual router receives. Create a virtual
     * router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual
     * services within your mesh. After you create your virtual router, create and associate routes for your virtual
     * router that direct incoming requests to different virtual nodes.
     * </p>
     * <p>
     * For more information about virtual routers, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVirtualRouterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVirtualRouterRequest#builder()}
     * </p>
     *
     * @param createVirtualRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualRouterResponse> createVirtualRouter(
            Consumer<CreateVirtualRouterRequest.Builder> createVirtualRouterRequest) {
        return createVirtualRouter(CreateVirtualRouterRequest.builder().applyMutation(createVirtualRouterRequest).build());
    }

    /**
     * <p>
     * Creates a virtual service within a service mesh.
     * </p>
     * <p>
     * A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly
     * by means of a virtual router. Dependent services call your virtual service by its <code>virtualServiceName</code>
     * , and those requests are routed to the virtual node or virtual router that is specified as the provider for the
     * virtual service.
     * </p>
     * <p>
     * For more information about virtual services, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services</a>.
     * </p>
     *
     * @param createVirtualServiceRequest
     * @return A Java Future containing the result of the CreateVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualServiceResponse> createVirtualService(
            CreateVirtualServiceRequest createVirtualServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual service within a service mesh.
     * </p>
     * <p>
     * A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly
     * by means of a virtual router. Dependent services call your virtual service by its <code>virtualServiceName</code>
     * , and those requests are routed to the virtual node or virtual router that is specified as the provider for the
     * virtual service.
     * </p>
     * <p>
     * For more information about virtual services, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVirtualServiceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVirtualServiceRequest#builder()}
     * </p>
     *
     * @param createVirtualServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.CreateVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualServiceResponse> createVirtualService(
            Consumer<CreateVirtualServiceRequest.Builder> createVirtualServiceRequest) {
        return createVirtualService(CreateVirtualServiceRequest.builder().applyMutation(createVirtualServiceRequest).build());
    }

    /**
     * <p>
     * Deletes an existing gateway route.
     * </p>
     *
     * @param deleteGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayRouteResponse> deleteGatewayRoute(DeleteGatewayRouteRequest deleteGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing gateway route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRouteRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayRouteRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayRouteResponse> deleteGatewayRoute(
            Consumer<DeleteGatewayRouteRequest.Builder> deleteGatewayRouteRequest) {
        return deleteGatewayRoute(DeleteGatewayRouteRequest.builder().applyMutation(deleteGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Deletes an existing service mesh.
     * </p>
     * <p>
     * You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh
     * before you can delete the mesh itself.
     * </p>
     *
     * @param deleteMeshRequest
     * @return A Java Future containing the result of the DeleteMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMeshResponse> deleteMesh(DeleteMeshRequest deleteMeshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing service mesh.
     * </p>
     * <p>
     * You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh
     * before you can delete the mesh itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMeshRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMeshRequest#builder()}
     * </p>
     *
     * @param deleteMeshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMeshResponse> deleteMesh(Consumer<DeleteMeshRequest.Builder> deleteMeshRequest) {
        return deleteMesh(DeleteMeshRequest.builder().applyMutation(deleteMeshRequest).build());
    }

    /**
     * <p>
     * Deletes an existing route.
     * </p>
     *
     * @param deleteRouteRequest
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRouteResponse> deleteRoute(DeleteRouteRequest deleteRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRouteRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRouteResponse> deleteRoute(Consumer<DeleteRouteRequest.Builder> deleteRouteRequest) {
        return deleteRoute(DeleteRouteRequest.builder().applyMutation(deleteRouteRequest).build());
    }

    /**
     * <p>
     * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to
     * it.
     * </p>
     *
     * @param deleteVirtualGatewayRequest
     * @return A Java Future containing the result of the DeleteVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualGatewayResponse> deleteVirtualGateway(
            DeleteVirtualGatewayRequest deleteVirtualGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to
     * it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVirtualGatewayRequest#builder()}
     * </p>
     *
     * @param deleteVirtualGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualGatewayResponse> deleteVirtualGateway(
            Consumer<DeleteVirtualGatewayRequest.Builder> deleteVirtualGatewayRequest) {
        return deleteVirtualGateway(DeleteVirtualGatewayRequest.builder().applyMutation(deleteVirtualGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes an existing virtual node.
     * </p>
     * <p>
     * You must delete any virtual services that list a virtual node as a service provider before you can delete the
     * virtual node itself.
     * </p>
     *
     * @param deleteVirtualNodeRequest
     *        Deletes a virtual node input.
     * @return A Java Future containing the result of the DeleteVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVirtualNodeResponse> deleteVirtualNode(DeleteVirtualNodeRequest deleteVirtualNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing virtual node.
     * </p>
     * <p>
     * You must delete any virtual services that list a virtual node as a service provider before you can delete the
     * virtual node itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualNodeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVirtualNodeRequest#builder()}
     * </p>
     *
     * @param deleteVirtualNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest.Builder} to create a
     *        request. Deletes a virtual node input.
     * @return A Java Future containing the result of the DeleteVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVirtualNodeResponse> deleteVirtualNode(
            Consumer<DeleteVirtualNodeRequest.Builder> deleteVirtualNodeRequest) {
        return deleteVirtualNode(DeleteVirtualNodeRequest.builder().applyMutation(deleteVirtualNodeRequest).build());
    }

    /**
     * <p>
     * Deletes an existing virtual router.
     * </p>
     * <p>
     * You must delete any routes associated with the virtual router before you can delete the router itself.
     * </p>
     *
     * @param deleteVirtualRouterRequest
     * @return A Java Future containing the result of the DeleteVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualRouterResponse> deleteVirtualRouter(
            DeleteVirtualRouterRequest deleteVirtualRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing virtual router.
     * </p>
     * <p>
     * You must delete any routes associated with the virtual router before you can delete the router itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualRouterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVirtualRouterRequest#builder()}
     * </p>
     *
     * @param deleteVirtualRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualRouterResponse> deleteVirtualRouter(
            Consumer<DeleteVirtualRouterRequest.Builder> deleteVirtualRouterRequest) {
        return deleteVirtualRouter(DeleteVirtualRouterRequest.builder().applyMutation(deleteVirtualRouterRequest).build());
    }

    /**
     * <p>
     * Deletes an existing virtual service.
     * </p>
     *
     * @param deleteVirtualServiceRequest
     * @return A Java Future containing the result of the DeleteVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualServiceResponse> deleteVirtualService(
            DeleteVirtualServiceRequest deleteVirtualServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing virtual service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualServiceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVirtualServiceRequest#builder()}
     * </p>
     *
     * @param deleteVirtualServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ResourceInUseException You can't delete the specified resource because it's in use or required by
     *         another resource.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DeleteVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualServiceResponse> deleteVirtualService(
            Consumer<DeleteVirtualServiceRequest.Builder> deleteVirtualServiceRequest) {
        return deleteVirtualService(DeleteVirtualServiceRequest.builder().applyMutation(deleteVirtualServiceRequest).build());
    }

    /**
     * <p>
     * Describes an existing gateway route.
     * </p>
     *
     * @param describeGatewayRouteRequest
     * @return A Java Future containing the result of the DescribeGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayRouteResponse> describeGatewayRoute(
            DescribeGatewayRouteRequest describeGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing gateway route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayRouteRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGatewayRouteRequest#builder()}
     * </p>
     *
     * @param describeGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayRouteResponse> describeGatewayRoute(
            Consumer<DescribeGatewayRouteRequest.Builder> describeGatewayRouteRequest) {
        return describeGatewayRoute(DescribeGatewayRouteRequest.builder().applyMutation(describeGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Describes an existing service mesh.
     * </p>
     *
     * @param describeMeshRequest
     * @return A Java Future containing the result of the DescribeMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeMeshResponse> describeMesh(DescribeMeshRequest describeMeshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMeshRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeMeshRequest#builder()}
     * </p>
     *
     * @param describeMeshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeMeshResponse> describeMesh(Consumer<DescribeMeshRequest.Builder> describeMeshRequest) {
        return describeMesh(DescribeMeshRequest.builder().applyMutation(describeMeshRequest).build());
    }

    /**
     * <p>
     * Describes an existing route.
     * </p>
     *
     * @param describeRouteRequest
     * @return A Java Future containing the result of the DescribeRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRouteResponse> describeRoute(DescribeRouteRequest describeRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRouteRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRouteRequest#builder()}
     * </p>
     *
     * @param describeRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRouteResponse> describeRoute(Consumer<DescribeRouteRequest.Builder> describeRouteRequest) {
        return describeRoute(DescribeRouteRequest.builder().applyMutation(describeRouteRequest).build());
    }

    /**
     * <p>
     * Describes an existing virtual gateway.
     * </p>
     *
     * @param describeVirtualGatewayRequest
     * @return A Java Future containing the result of the DescribeVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualGatewayResponse> describeVirtualGateway(
            DescribeVirtualGatewayRequest describeVirtualGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing virtual gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVirtualGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVirtualGatewayRequest#builder()}
     * </p>
     *
     * @param describeVirtualGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualGatewayResponse> describeVirtualGateway(
            Consumer<DescribeVirtualGatewayRequest.Builder> describeVirtualGatewayRequest) {
        return describeVirtualGateway(DescribeVirtualGatewayRequest.builder().applyMutation(describeVirtualGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Describes an existing virtual node.
     * </p>
     *
     * @param describeVirtualNodeRequest
     * @return A Java Future containing the result of the DescribeVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualNodeResponse> describeVirtualNode(
            DescribeVirtualNodeRequest describeVirtualNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing virtual node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVirtualNodeRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVirtualNodeRequest#builder()}
     * </p>
     *
     * @param describeVirtualNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualNodeResponse> describeVirtualNode(
            Consumer<DescribeVirtualNodeRequest.Builder> describeVirtualNodeRequest) {
        return describeVirtualNode(DescribeVirtualNodeRequest.builder().applyMutation(describeVirtualNodeRequest).build());
    }

    /**
     * <p>
     * Describes an existing virtual router.
     * </p>
     *
     * @param describeVirtualRouterRequest
     * @return A Java Future containing the result of the DescribeVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualRouterResponse> describeVirtualRouter(
            DescribeVirtualRouterRequest describeVirtualRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing virtual router.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVirtualRouterRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVirtualRouterRequest#builder()}
     * </p>
     *
     * @param describeVirtualRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualRouterResponse> describeVirtualRouter(
            Consumer<DescribeVirtualRouterRequest.Builder> describeVirtualRouterRequest) {
        return describeVirtualRouter(DescribeVirtualRouterRequest.builder().applyMutation(describeVirtualRouterRequest).build());
    }

    /**
     * <p>
     * Describes an existing virtual service.
     * </p>
     *
     * @param describeVirtualServiceRequest
     * @return A Java Future containing the result of the DescribeVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualService"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualServiceResponse> describeVirtualService(
            DescribeVirtualServiceRequest describeVirtualServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing virtual service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVirtualServiceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVirtualServiceRequest#builder()}
     * </p>
     *
     * @param describeVirtualServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.DescribeVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualService"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVirtualServiceResponse> describeVirtualService(
            Consumer<DescribeVirtualServiceRequest.Builder> describeVirtualServiceRequest) {
        return describeVirtualService(DescribeVirtualServiceRequest.builder().applyMutation(describeVirtualServiceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of existing gateway routes that are associated to a virtual gateway.
     * </p>
     *
     * @param listGatewayRoutesRequest
     * @return A Java Future containing the result of the ListGatewayRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListGatewayRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGatewayRoutesResponse> listGatewayRoutes(ListGatewayRoutesRequest listGatewayRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing gateway routes that are associated to a virtual gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayRoutesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGatewayRoutesRequest#builder()}
     * </p>
     *
     * @param listGatewayRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGatewayRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListGatewayRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGatewayRoutesResponse> listGatewayRoutes(
            Consumer<ListGatewayRoutesRequest.Builder> listGatewayRoutesRequest) {
        return listGatewayRoutes(ListGatewayRoutesRequest.builder().applyMutation(listGatewayRoutesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing gateway routes that are associated to a virtual gateway.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayRoutes(software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListGatewayRoutesPublisher publisher = client.listGatewayRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListGatewayRoutesPublisher publisher = client.listGatewayRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayRoutes(software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest)} operation.</b>
     * </p>
     *
     * @param listGatewayRoutesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListGatewayRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewayRoutesPublisher listGatewayRoutesPaginator(ListGatewayRoutesRequest listGatewayRoutesRequest) {
        return new ListGatewayRoutesPublisher(this, listGatewayRoutesRequest);
    }

    /**
     * <p>
     * Returns a list of existing gateway routes that are associated to a virtual gateway.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayRoutes(software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListGatewayRoutesPublisher publisher = client.listGatewayRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListGatewayRoutesPublisher publisher = client.listGatewayRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayRoutes(software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayRoutesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGatewayRoutesRequest#builder()}
     * </p>
     *
     * @param listGatewayRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListGatewayRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewayRoutesPublisher listGatewayRoutesPaginator(
            Consumer<ListGatewayRoutesRequest.Builder> listGatewayRoutesRequest) {
        return listGatewayRoutesPaginator(ListGatewayRoutesRequest.builder().applyMutation(listGatewayRoutesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing service meshes.
     * </p>
     *
     * @param listMeshesRequest
     * @return A Java Future containing the result of the ListMeshes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListMeshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeshesResponse> listMeshes(ListMeshesRequest listMeshesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing service meshes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeshesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMeshesRequest#builder()}
     * </p>
     *
     * @param listMeshesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListMeshesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMeshes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListMeshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeshesResponse> listMeshes(Consumer<ListMeshesRequest.Builder> listMeshesRequest) {
        return listMeshes(ListMeshesRequest.builder().applyMutation(listMeshesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing service meshes.
     * </p>
     *
     * @return A Java Future containing the result of the ListMeshes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListMeshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeshesResponse> listMeshes() {
        return listMeshes(ListMeshesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of existing service meshes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMeshes(software.amazon.awssdk.services.appmesh.model.ListMeshesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher publisher = client.listMeshesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher publisher = client.listMeshesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListMeshesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListMeshesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeshes(software.amazon.awssdk.services.appmesh.model.ListMeshesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListMeshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMeshesPublisher listMeshesPaginator() {
        return listMeshesPaginator(ListMeshesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of existing service meshes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMeshes(software.amazon.awssdk.services.appmesh.model.ListMeshesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher publisher = client.listMeshesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher publisher = client.listMeshesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListMeshesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListMeshesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeshes(software.amazon.awssdk.services.appmesh.model.ListMeshesRequest)} operation.</b>
     * </p>
     *
     * @param listMeshesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListMeshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMeshesPublisher listMeshesPaginator(ListMeshesRequest listMeshesRequest) {
        return new ListMeshesPublisher(this, listMeshesRequest);
    }

    /**
     * <p>
     * Returns a list of existing service meshes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMeshes(software.amazon.awssdk.services.appmesh.model.ListMeshesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher publisher = client.listMeshesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListMeshesPublisher publisher = client.listMeshesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListMeshesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListMeshesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeshes(software.amazon.awssdk.services.appmesh.model.ListMeshesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeshesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMeshesRequest#builder()}
     * </p>
     *
     * @param listMeshesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListMeshesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListMeshes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListMeshes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMeshesPublisher listMeshesPaginator(Consumer<ListMeshesRequest.Builder> listMeshesRequest) {
        return listMeshesPaginator(ListMeshesRequest.builder().applyMutation(listMeshesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing routes in a service mesh.
     * </p>
     *
     * @param listRoutesRequest
     * @return A Java Future containing the result of the ListRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoutesResponse> listRoutes(ListRoutesRequest listRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing routes in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoutesRequest#builder()}
     * </p>
     *
     * @param listRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListRoutesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoutesResponse> listRoutes(Consumer<ListRoutesRequest.Builder> listRoutesRequest) {
        return listRoutes(ListRoutesRequest.builder().applyMutation(listRoutesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing routes in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRoutes(software.amazon.awssdk.services.appmesh.model.ListRoutesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListRoutesPublisher publisher = client.listRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListRoutesPublisher publisher = client.listRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutes(software.amazon.awssdk.services.appmesh.model.ListRoutesRequest)} operation.</b>
     * </p>
     *
     * @param listRoutesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoutesPublisher listRoutesPaginator(ListRoutesRequest listRoutesRequest) {
        return new ListRoutesPublisher(this, listRoutesRequest);
    }

    /**
     * <p>
     * Returns a list of existing routes in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRoutes(software.amazon.awssdk.services.appmesh.model.ListRoutesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListRoutesPublisher publisher = client.listRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListRoutesPublisher publisher = client.listRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutes(software.amazon.awssdk.services.appmesh.model.ListRoutesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoutesRequest#builder()}
     * </p>
     *
     * @param listRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListRoutesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoutesPublisher listRoutesPaginator(Consumer<ListRoutesRequest.Builder> listRoutesRequest) {
        return listRoutesPaginator(ListRoutesRequest.builder().applyMutation(listRoutesRequest).build());
    }

    /**
     * <p>
     * List the tags for an App Mesh resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an App Mesh resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List the tags for an App Mesh resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * List the tags for an App Mesh resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of existing virtual gateways in a service mesh.
     * </p>
     *
     * @param listVirtualGatewaysRequest
     * @return A Java Future containing the result of the ListVirtualGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVirtualGatewaysResponse> listVirtualGateways(
            ListVirtualGatewaysRequest listVirtualGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing virtual gateways in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualGatewaysRequest#builder()}
     * </p>
     *
     * @param listVirtualGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVirtualGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVirtualGatewaysResponse> listVirtualGateways(
            Consumer<ListVirtualGatewaysRequest.Builder> listVirtualGatewaysRequest) {
        return listVirtualGateways(ListVirtualGatewaysRequest.builder().applyMutation(listVirtualGatewaysRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing virtual gateways in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualGateways(software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualGatewaysPublisher publisher = client.listVirtualGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualGatewaysPublisher publisher = client.listVirtualGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualGateways(software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVirtualGatewaysPublisher listVirtualGatewaysPaginator(ListVirtualGatewaysRequest listVirtualGatewaysRequest) {
        return new ListVirtualGatewaysPublisher(this, listVirtualGatewaysRequest);
    }

    /**
     * <p>
     * Returns a list of existing virtual gateways in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualGateways(software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualGatewaysPublisher publisher = client.listVirtualGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualGatewaysPublisher publisher = client.listVirtualGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualGateways(software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualGatewaysRequest#builder()}
     * </p>
     *
     * @param listVirtualGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVirtualGatewaysPublisher listVirtualGatewaysPaginator(
            Consumer<ListVirtualGatewaysRequest.Builder> listVirtualGatewaysRequest) {
        return listVirtualGatewaysPaginator(ListVirtualGatewaysRequest.builder().applyMutation(listVirtualGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of existing virtual nodes.
     * </p>
     *
     * @param listVirtualNodesRequest
     * @return A Java Future containing the result of the ListVirtualNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVirtualNodesResponse> listVirtualNodes(ListVirtualNodesRequest listVirtualNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing virtual nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualNodesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVirtualNodesRequest#builder()}
     * </p>
     *
     * @param listVirtualNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVirtualNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVirtualNodesResponse> listVirtualNodes(
            Consumer<ListVirtualNodesRequest.Builder> listVirtualNodesRequest) {
        return listVirtualNodes(ListVirtualNodesRequest.builder().applyMutation(listVirtualNodesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing virtual nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualNodes(software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualNodesPublisher publisher = client.listVirtualNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualNodesPublisher publisher = client.listVirtualNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualNodes(software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest)} operation.</b>
     * </p>
     *
     * @param listVirtualNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualNodesPublisher listVirtualNodesPaginator(ListVirtualNodesRequest listVirtualNodesRequest) {
        return new ListVirtualNodesPublisher(this, listVirtualNodesRequest);
    }

    /**
     * <p>
     * Returns a list of existing virtual nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualNodes(software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualNodesPublisher publisher = client.listVirtualNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualNodesPublisher publisher = client.listVirtualNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualNodes(software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualNodesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVirtualNodesRequest#builder()}
     * </p>
     *
     * @param listVirtualNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVirtualNodesPublisher listVirtualNodesPaginator(Consumer<ListVirtualNodesRequest.Builder> listVirtualNodesRequest) {
        return listVirtualNodesPaginator(ListVirtualNodesRequest.builder().applyMutation(listVirtualNodesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing virtual routers in a service mesh.
     * </p>
     *
     * @param listVirtualRoutersRequest
     * @return A Java Future containing the result of the ListVirtualRouters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVirtualRoutersResponse> listVirtualRouters(ListVirtualRoutersRequest listVirtualRoutersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing virtual routers in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualRoutersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualRoutersRequest#builder()}
     * </p>
     *
     * @param listVirtualRoutersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVirtualRouters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVirtualRoutersResponse> listVirtualRouters(
            Consumer<ListVirtualRoutersRequest.Builder> listVirtualRoutersRequest) {
        return listVirtualRouters(ListVirtualRoutersRequest.builder().applyMutation(listVirtualRoutersRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing virtual routers in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualRouters(software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualRoutersPublisher publisher = client.listVirtualRoutersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualRoutersPublisher publisher = client.listVirtualRoutersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualRouters(software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualRoutersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVirtualRoutersPublisher listVirtualRoutersPaginator(ListVirtualRoutersRequest listVirtualRoutersRequest) {
        return new ListVirtualRoutersPublisher(this, listVirtualRoutersRequest);
    }

    /**
     * <p>
     * Returns a list of existing virtual routers in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualRouters(software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualRoutersPublisher publisher = client.listVirtualRoutersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualRoutersPublisher publisher = client.listVirtualRoutersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualRouters(software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualRoutersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualRoutersRequest#builder()}
     * </p>
     *
     * @param listVirtualRoutersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualRouters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualRouters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVirtualRoutersPublisher listVirtualRoutersPaginator(
            Consumer<ListVirtualRoutersRequest.Builder> listVirtualRoutersRequest) {
        return listVirtualRoutersPaginator(ListVirtualRoutersRequest.builder().applyMutation(listVirtualRoutersRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing virtual services in a service mesh.
     * </p>
     *
     * @param listVirtualServicesRequest
     * @return A Java Future containing the result of the ListVirtualServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVirtualServicesResponse> listVirtualServices(
            ListVirtualServicesRequest listVirtualServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing virtual services in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualServicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualServicesRequest#builder()}
     * </p>
     *
     * @param listVirtualServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVirtualServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVirtualServicesResponse> listVirtualServices(
            Consumer<ListVirtualServicesRequest.Builder> listVirtualServicesRequest) {
        return listVirtualServices(ListVirtualServicesRequest.builder().applyMutation(listVirtualServicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing virtual services in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualServices(software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualServicesPublisher publisher = client.listVirtualServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualServicesPublisher publisher = client.listVirtualServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualServices(software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVirtualServicesPublisher listVirtualServicesPaginator(ListVirtualServicesRequest listVirtualServicesRequest) {
        return new ListVirtualServicesPublisher(this, listVirtualServicesRequest);
    }

    /**
     * <p>
     * Returns a list of existing virtual services in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualServices(software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualServicesPublisher publisher = client.listVirtualServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appmesh.paginators.ListVirtualServicesPublisher publisher = client.listVirtualServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualServices(software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualServicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualServicesRequest#builder()}
     * </p>
     *
     * @param listVirtualServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.ListVirtualServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListVirtualServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVirtualServicesPublisher listVirtualServicesPaginator(
            Consumer<ListVirtualServicesRequest.Builder> listVirtualServicesRequest) {
        return listVirtualServicesPaginator(ListVirtualServicesRequest.builder().applyMutation(listVirtualServicesRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyTagsException The request exceeds the maximum allowed number of tags allowed per resource. The
     *         current limit is 50 user tags per resource. You must reduce the number of tags in the request. None of
     *         the tags in this request were applied.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyTagsException The request exceeds the maximum allowed number of tags allowed per resource. The
     *         current limit is 50 user tags per resource. You must reduce the number of tags in the request. None of
     *         the tags in this request were applied.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.
     * </p>
     *
     * @param updateGatewayRouteRequest
     * @return A Java Future containing the result of the UpdateGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayRouteResponse> updateGatewayRoute(UpdateGatewayRouteRequest updateGatewayRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRouteRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayRouteRequest#builder()}
     * </p>
     *
     * @param updateGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayRouteResponse> updateGatewayRoute(
            Consumer<UpdateGatewayRouteRequest.Builder> updateGatewayRouteRequest) {
        return updateGatewayRoute(UpdateGatewayRouteRequest.builder().applyMutation(updateGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Updates an existing service mesh.
     * </p>
     *
     * @param updateMeshRequest
     * @return A Java Future containing the result of the UpdateMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMeshResponse> updateMesh(UpdateMeshRequest updateMeshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMeshRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMeshRequest#builder()}
     * </p>
     *
     * @param updateMeshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMesh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateMesh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMesh" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMeshResponse> updateMesh(Consumer<UpdateMeshRequest.Builder> updateMeshRequest) {
        return updateMesh(UpdateMeshRequest.builder().applyMutation(updateMeshRequest).build());
    }

    /**
     * <p>
     * Updates an existing route for a specified service mesh and virtual router.
     * </p>
     *
     * @param updateRouteRequest
     * @return A Java Future containing the result of the UpdateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRouteResponse> updateRoute(UpdateRouteRequest updateRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing route for a specified service mesh and virtual router.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRouteRequest#builder()}
     * </p>
     *
     * @param updateRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRouteResponse> updateRoute(Consumer<UpdateRouteRequest.Builder> updateRouteRequest) {
        return updateRoute(UpdateRouteRequest.builder().applyMutation(updateRouteRequest).build());
    }

    /**
     * <p>
     * Updates an existing virtual gateway in a specified service mesh.
     * </p>
     *
     * @param updateVirtualGatewayRequest
     * @return A Java Future containing the result of the UpdateVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVirtualGatewayResponse> updateVirtualGateway(
            UpdateVirtualGatewayRequest updateVirtualGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing virtual gateway in a specified service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVirtualGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVirtualGatewayRequest#builder()}
     * </p>
     *
     * @param updateVirtualGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVirtualGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVirtualGatewayResponse> updateVirtualGateway(
            Consumer<UpdateVirtualGatewayRequest.Builder> updateVirtualGatewayRequest) {
        return updateVirtualGateway(UpdateVirtualGatewayRequest.builder().applyMutation(updateVirtualGatewayRequest).build());
    }

    /**
     * <p>
     * Updates an existing virtual node in a specified service mesh.
     * </p>
     *
     * @param updateVirtualNodeRequest
     * @return A Java Future containing the result of the UpdateVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVirtualNodeResponse> updateVirtualNode(UpdateVirtualNodeRequest updateVirtualNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing virtual node in a specified service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVirtualNodeRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVirtualNodeRequest#builder()}
     * </p>
     *
     * @param updateVirtualNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVirtualNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVirtualNodeResponse> updateVirtualNode(
            Consumer<UpdateVirtualNodeRequest.Builder> updateVirtualNodeRequest) {
        return updateVirtualNode(UpdateVirtualNodeRequest.builder().applyMutation(updateVirtualNodeRequest).build());
    }

    /**
     * <p>
     * Updates an existing virtual router in a specified service mesh.
     * </p>
     *
     * @param updateVirtualRouterRequest
     * @return A Java Future containing the result of the UpdateVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVirtualRouterResponse> updateVirtualRouter(
            UpdateVirtualRouterRequest updateVirtualRouterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing virtual router in a specified service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVirtualRouterRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVirtualRouterRequest#builder()}
     * </p>
     *
     * @param updateVirtualRouterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVirtualRouter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualRouter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualRouter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVirtualRouterResponse> updateVirtualRouter(
            Consumer<UpdateVirtualRouterRequest.Builder> updateVirtualRouterRequest) {
        return updateVirtualRouter(UpdateVirtualRouterRequest.builder().applyMutation(updateVirtualRouterRequest).build());
    }

    /**
     * <p>
     * Updates an existing virtual service in a specified service mesh.
     * </p>
     *
     * @param updateVirtualServiceRequest
     * @return A Java Future containing the result of the UpdateVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVirtualServiceResponse> updateVirtualService(
            UpdateVirtualServiceRequest updateVirtualServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing virtual service in a specified service mesh.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVirtualServiceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVirtualServiceRequest#builder()}
     * </p>
     *
     * @param updateVirtualServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVirtualService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified resource doesn't exist. Check your request syntax and try again.</li>
     *         <li>BadRequestException The request syntax was malformed. Check your request syntax and try again.</li>
     *         <li>ConflictException The request contains a client token that was used for a previous update resource
     *         call with different specifications. Try the request again with a new client token.</li>
     *         <li>TooManyRequestsException The maximum request rate permitted by the App Mesh APIs has been exceeded
     *         for your account. For best results, use an increasing or variable sleep interval between requests.</li>
     *         <li>ForbiddenException You don't have permissions to perform this action.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the service.</li>
     *         <li>InternalServerErrorException The request processing has failed because of an unknown error,
     *         exception, or failure.</li>
     *         <li>LimitExceededException You have exceeded a service limit for your account. For more information, see
     *         <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in
     *         the <i>App Mesh User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppMeshException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppMeshAsyncClient.UpdateVirtualService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVirtualServiceResponse> updateVirtualService(
            Consumer<UpdateVirtualServiceRequest.Builder> updateVirtualServiceRequest) {
        return updateVirtualService(UpdateVirtualServiceRequest.builder().applyMutation(updateVirtualServiceRequest).build());
    }

    @Override
    default AppMeshServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppMeshAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppMeshAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppMeshAsyncClient}.
     */
    static AppMeshAsyncClientBuilder builder() {
        return new DefaultAppMeshAsyncClientBuilder();
    }
}
