/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PortProtocol {
    HTTP("http"),
    TCP("tcp"),
    HTTP2("http2"),
    GRPC("grpc"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PortProtocol> VALUE_MAP;
    private final String value;

    private PortProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortProtocol> knownValues() {
        EnumSet<PortProtocol> knownValues = EnumSet.allOf(PortProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PortProtocol.class, PortProtocol::toString);
    }
}

