/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteRef;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse;

public class ListGatewayRoutesIterable
implements SdkIterable<ListGatewayRoutesResponse> {
    private final AppMeshClient client;
    private final ListGatewayRoutesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewayRoutesIterable(AppMeshClient client, ListGatewayRoutesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGatewayRoutesResponseFetcher();
    }

    public Iterator<ListGatewayRoutesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GatewayRouteRef> gatewayRoutes() {
        Function<ListGatewayRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.gatewayRoutes() != null) {
                return response.gatewayRoutes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGatewayRoutesResponseFetcher
    implements SyncPageFetcher<ListGatewayRoutesResponse> {
        private ListGatewayRoutesResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGatewayRoutesResponse nextPage(ListGatewayRoutesResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayRoutesIterable.this.client.listGatewayRoutes(ListGatewayRoutesIterable.this.firstRequest);
            }
            return ListGatewayRoutesIterable.this.client.listGatewayRoutes((ListGatewayRoutesRequest)((Object)ListGatewayRoutesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

