/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterListCopier;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualRoutersResponse
extends AppMeshResponse
implements ToCopyableBuilder<Builder, ListVirtualRoutersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVirtualRoutersResponse.getter(ListVirtualRoutersResponse::nextToken)).setter(ListVirtualRoutersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VirtualRouterRef>> VIRTUAL_ROUTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("virtualRouters").getter(ListVirtualRoutersResponse.getter(ListVirtualRoutersResponse::virtualRouters)).setter(ListVirtualRoutersResponse.setter(Builder::virtualRouters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualRouterRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VIRTUAL_ROUTERS_FIELD));
    private final String nextToken;
    private final List<VirtualRouterRef> virtualRouters;

    private ListVirtualRoutersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualRouters = builder.virtualRouters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVirtualRouters() {
        return this.virtualRouters != null && !(this.virtualRouters instanceof SdkAutoConstructList);
    }

    public final List<VirtualRouterRef> virtualRouters() {
        return this.virtualRouters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualRouters() ? this.virtualRouters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualRoutersResponse)) {
            return false;
        }
        ListVirtualRoutersResponse other = (ListVirtualRoutersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVirtualRouters() == other.hasVirtualRouters() && Objects.equals(this.virtualRouters(), other.virtualRouters());
    }

    public final String toString() {
        return ToString.builder((String)"ListVirtualRoutersResponse").add("NextToken", (Object)this.nextToken()).add("VirtualRouters", this.hasVirtualRouters() ? this.virtualRouters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "virtualRouters": {
                return Optional.ofNullable(clazz.cast(this.virtualRouters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualRoutersResponse, T> g) {
        return obj -> g.apply((ListVirtualRoutersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VirtualRouterRef> virtualRouters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualRoutersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.virtualRouters(model.virtualRouters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VirtualRouterRef.Builder> getVirtualRouters() {
            List<VirtualRouterRef.Builder> result = VirtualRouterListCopier.copyToBuilder(this.virtualRouters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualRouters(Collection<VirtualRouterRef.BuilderImpl> virtualRouters) {
            this.virtualRouters = VirtualRouterListCopier.copyFromBuilder(virtualRouters);
        }

        @Override
        public final Builder virtualRouters(Collection<VirtualRouterRef> virtualRouters) {
            this.virtualRouters = VirtualRouterListCopier.copy(virtualRouters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualRouters(VirtualRouterRef ... virtualRouters) {
            this.virtualRouters(Arrays.asList(virtualRouters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualRouters(Consumer<VirtualRouterRef.Builder> ... virtualRouters) {
            this.virtualRouters(Stream.of(virtualRouters).map(c -> (VirtualRouterRef)((VirtualRouterRef.Builder)VirtualRouterRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVirtualRoutersResponse build() {
            return new ListVirtualRoutersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualRoutersResponse> {
        public Builder nextToken(String var1);

        public Builder virtualRouters(Collection<VirtualRouterRef> var1);

        public Builder virtualRouters(VirtualRouterRef ... var1);

        public Builder virtualRouters(Consumer<VirtualRouterRef.Builder> ... var1);
    }
}

