/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVirtualGatewayRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, UpdateVirtualGatewayRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateVirtualGatewayRequest.getter(UpdateVirtualGatewayRequest::clientToken)).setter(UpdateVirtualGatewayRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(UpdateVirtualGatewayRequest.getter(UpdateVirtualGatewayRequest::meshName)).setter(UpdateVirtualGatewayRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshOwner").getter(UpdateVirtualGatewayRequest.getter(UpdateVirtualGatewayRequest::meshOwner)).setter(UpdateVirtualGatewayRequest.setter(Builder::meshOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()}).build();
    private static final SdkField<VirtualGatewaySpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(UpdateVirtualGatewayRequest.getter(UpdateVirtualGatewayRequest::spec)).setter(UpdateVirtualGatewayRequest.setter(Builder::spec)).constructor(VirtualGatewaySpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayName").getter(UpdateVirtualGatewayRequest.getter(UpdateVirtualGatewayRequest::virtualGatewayName)).setter(UpdateVirtualGatewayRequest.setter(Builder::virtualGatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));
    private final String clientToken;
    private final String meshName;
    private final String meshOwner;
    private final VirtualGatewaySpec spec;
    private final String virtualGatewayName;

    private UpdateVirtualGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final String meshOwner() {
        return this.meshOwner;
    }

    public final VirtualGatewaySpec spec() {
        return this.spec;
    }

    public final String virtualGatewayName() {
        return this.virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualGatewayRequest)) {
            return false;
        }
        UpdateVirtualGatewayRequest other = (UpdateVirtualGatewayRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.meshOwner(), other.meshOwner()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.virtualGatewayName(), other.virtualGatewayName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVirtualGatewayRequest").add("ClientToken", (Object)this.clientToken()).add("MeshName", (Object)this.meshName()).add("MeshOwner", (Object)this.meshOwner()).add("Spec", (Object)this.spec()).add("VirtualGatewayName", (Object)this.virtualGatewayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "meshOwner": {
                return Optional.ofNullable(clazz.cast(this.meshOwner()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "virtualGatewayName": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualGatewayRequest, T> g) {
        return obj -> g.apply((UpdateVirtualGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String meshName;
        private String meshOwner;
        private VirtualGatewaySpec spec;
        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualGatewayRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.meshName(model.meshName);
            this.meshOwner(model.meshOwner);
            this.spec(model.spec);
            this.virtualGatewayName(model.virtualGatewayName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        @Transient
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return this.meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        @Transient
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final VirtualGatewaySpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        public final void setSpec(VirtualGatewaySpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        @Transient
        public final Builder spec(VirtualGatewaySpec spec) {
            this.spec = spec;
            return this;
        }

        public final String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        @Transient
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualGatewayRequest build() {
            return new UpdateVirtualGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVirtualGatewayRequest> {
        public Builder clientToken(String var1);

        public Builder meshName(String var1);

        public Builder meshOwner(String var1);

        public Builder spec(VirtualGatewaySpec var1);

        default public Builder spec(Consumer<VirtualGatewaySpec.Builder> spec) {
            return this.spec((VirtualGatewaySpec)((VirtualGatewaySpec.Builder)VirtualGatewaySpec.builder().applyMutation(spec)).build());
        }

        public Builder virtualGatewayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

