/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshResponse;
import software.amazon.awssdk.services.appmesh.model.MeshListCopier;
import software.amazon.awssdk.services.appmesh.model.MeshRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMeshesResponse
extends AppMeshResponse
implements ToCopyableBuilder<Builder, ListMeshesResponse> {
    private static final SdkField<List<MeshRef>> MESHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("meshes").getter(ListMeshesResponse.getter(ListMeshesResponse::meshes)).setter(ListMeshesResponse.setter(Builder::meshes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeshRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMeshesResponse.getter(ListMeshesResponse::nextToken)).setter(ListMeshesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESHES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MeshRef> meshes;
    private final String nextToken;

    private ListMeshesResponse(BuilderImpl builder) {
        super(builder);
        this.meshes = builder.meshes;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMeshes() {
        return this.meshes != null && !(this.meshes instanceof SdkAutoConstructList);
    }

    public List<MeshRef> meshes() {
        return this.meshes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meshes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMeshesResponse)) {
            return false;
        }
        ListMeshesResponse other = (ListMeshesResponse)((Object)obj);
        return Objects.equals(this.meshes(), other.meshes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMeshesResponse").add("Meshes", this.meshes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshes": {
                return Optional.ofNullable(clazz.cast(this.meshes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMeshesResponse, T> g) {
        return obj -> g.apply((ListMeshesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshResponse.BuilderImpl
    implements Builder {
        private List<MeshRef> meshes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMeshesResponse model) {
            super(model);
            this.meshes(model.meshes);
            this.nextToken(model.nextToken);
        }

        public final Collection<MeshRef.Builder> getMeshes() {
            return this.meshes != null ? (Collection)this.meshes.stream().map(MeshRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder meshes(Collection<MeshRef> meshes) {
            this.meshes = MeshListCopier.copy(meshes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meshes(MeshRef ... meshes) {
            this.meshes(Arrays.asList(meshes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meshes(Consumer<MeshRef.Builder> ... meshes) {
            this.meshes(Stream.of(meshes).map(c -> (MeshRef)((MeshRef.Builder)MeshRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMeshes(Collection<MeshRef.BuilderImpl> meshes) {
            this.meshes = MeshListCopier.copyFromBuilder(meshes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMeshesResponse build() {
            return new ListMeshesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMeshesResponse> {
        public Builder meshes(Collection<MeshRef> var1);

        public Builder meshes(MeshRef ... var1);

        public Builder meshes(Consumer<MeshRef.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

