/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayRef;

public class ListVirtualGatewaysIterable
implements SdkIterable<ListVirtualGatewaysResponse> {
    private final AppMeshClient client;
    private final ListVirtualGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualGatewaysIterable(AppMeshClient client, ListVirtualGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVirtualGatewaysResponseFetcher();
    }

    public Iterator<ListVirtualGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualGatewayRef> virtualGateways() {
        Function<ListVirtualGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualGateways() != null) {
                return response.virtualGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVirtualGatewaysResponseFetcher
    implements SyncPageFetcher<ListVirtualGatewaysResponse> {
        private ListVirtualGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVirtualGatewaysResponse nextPage(ListVirtualGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualGatewaysIterable.this.client.listVirtualGateways(ListVirtualGatewaysIterable.this.firstRequest);
            }
            return ListVirtualGatewaysIterable.this.client.listVirtualGateways((ListVirtualGatewaysRequest)((Object)ListVirtualGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

