/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.GrpcRouteMetadata;
import software.amazon.awssdk.services.appmesh.model.GrpcRouteMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrpcRouteMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrpcRouteMatch> {
    private static final SdkField<List<GrpcRouteMetadata>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadata").getter(GrpcRouteMatch.getter(GrpcRouteMatch::metadata)).setter(GrpcRouteMatch.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrpcRouteMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METHOD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("methodName").getter(GrpcRouteMatch.getter(GrpcRouteMatch::methodName)).setter(GrpcRouteMatch.setter(Builder::methodName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(GrpcRouteMatch.getter(GrpcRouteMatch::serviceName)).setter(GrpcRouteMatch.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, METHOD_NAME_FIELD, SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<GrpcRouteMetadata> metadata;
    private final String methodName;
    private final String serviceName;

    private GrpcRouteMatch(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.methodName = builder.methodName;
        this.serviceName = builder.serviceName;
    }

    public boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructList);
    }

    public List<GrpcRouteMetadata> metadata() {
        return this.metadata;
    }

    public String methodName() {
        return this.methodName;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.methodName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRouteMatch)) {
            return false;
        }
        GrpcRouteMatch other = (GrpcRouteMatch)obj;
        return this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.methodName(), other.methodName()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public String toString() {
        return ToString.builder((String)"GrpcRouteMatch").add("Metadata", this.hasMetadata() ? this.metadata() : null).add("MethodName", (Object)this.methodName()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "methodName": {
                return Optional.ofNullable(clazz.cast(this.methodName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRouteMatch, T> g) {
        return obj -> g.apply((GrpcRouteMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GrpcRouteMetadata> metadata = DefaultSdkAutoConstructList.getInstance();
        private String methodName;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRouteMatch model) {
            this.metadata(model.metadata);
            this.methodName(model.methodName);
            this.serviceName(model.serviceName);
        }

        public final Collection<GrpcRouteMetadata.Builder> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metadata != null ? (Collection)this.metadata.stream().map(GrpcRouteMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metadata(Collection<GrpcRouteMetadata> metadata) {
            this.metadata = GrpcRouteMetadataListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(GrpcRouteMetadata ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Consumer<GrpcRouteMetadata.Builder> ... metadata) {
            this.metadata(Stream.of(metadata).map(c -> (GrpcRouteMetadata)((GrpcRouteMetadata.Builder)GrpcRouteMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetadata(Collection<GrpcRouteMetadata.BuilderImpl> metadata) {
            this.metadata = GrpcRouteMetadataListCopier.copyFromBuilder(metadata);
        }

        public final String getMethodName() {
            return this.methodName;
        }

        @Override
        public final Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public final void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public GrpcRouteMatch build() {
            return new GrpcRouteMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrpcRouteMatch> {
        public Builder metadata(Collection<GrpcRouteMetadata> var1);

        public Builder metadata(GrpcRouteMetadata ... var1);

        public Builder metadata(Consumer<GrpcRouteMetadata.Builder> ... var1);

        public Builder methodName(String var1);

        public Builder serviceName(String var1);
    }
}

