/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualNodeHttpConnectionPool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualNodeHttpConnectionPool> {
    private static final SdkField<Integer> MAX_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxConnections").getter(VirtualNodeHttpConnectionPool.getter(VirtualNodeHttpConnectionPool::maxConnections)).setter(VirtualNodeHttpConnectionPool.setter(Builder::maxConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConnections").build()}).build();
    private static final SdkField<Integer> MAX_PENDING_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxPendingRequests").getter(VirtualNodeHttpConnectionPool.getter(VirtualNodeHttpConnectionPool::maxPendingRequests)).setter(VirtualNodeHttpConnectionPool.setter(Builder::maxPendingRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPendingRequests").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONNECTIONS_FIELD, MAX_PENDING_REQUESTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxConnections;
    private final Integer maxPendingRequests;

    private VirtualNodeHttpConnectionPool(BuilderImpl builder) {
        this.maxConnections = builder.maxConnections;
        this.maxPendingRequests = builder.maxPendingRequests;
    }

    public Integer maxConnections() {
        return this.maxConnections;
    }

    public Integer maxPendingRequests() {
        return this.maxPendingRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPendingRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeHttpConnectionPool)) {
            return false;
        }
        VirtualNodeHttpConnectionPool other = (VirtualNodeHttpConnectionPool)obj;
        return Objects.equals(this.maxConnections(), other.maxConnections()) && Objects.equals(this.maxPendingRequests(), other.maxPendingRequests());
    }

    public String toString() {
        return ToString.builder((String)"VirtualNodeHttpConnectionPool").add("MaxConnections", (Object)this.maxConnections()).add("MaxPendingRequests", (Object)this.maxPendingRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxConnections": {
                return Optional.ofNullable(clazz.cast(this.maxConnections()));
            }
            case "maxPendingRequests": {
                return Optional.ofNullable(clazz.cast(this.maxPendingRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeHttpConnectionPool, T> g) {
        return obj -> g.apply((VirtualNodeHttpConnectionPool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxConnections;
        private Integer maxPendingRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeHttpConnectionPool model) {
            this.maxConnections(model.maxConnections);
            this.maxPendingRequests(model.maxPendingRequests);
        }

        public final Integer getMaxConnections() {
            return this.maxConnections;
        }

        @Override
        public final Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public final void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public final Integer getMaxPendingRequests() {
            return this.maxPendingRequests;
        }

        @Override
        public final Builder maxPendingRequests(Integer maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
            return this;
        }

        public final void setMaxPendingRequests(Integer maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
        }

        public VirtualNodeHttpConnectionPool build() {
            return new VirtualNodeHttpConnectionPool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualNodeHttpConnectionPool> {
        public Builder maxConnections(Integer var1);

        public Builder maxPendingRequests(Integer var1);
    }
}

