/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.WeightedTarget;
import software.amazon.awssdk.services.appmesh.model.WeightedTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrpcRouteAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrpcRouteAction> {
    private static final SdkField<List<WeightedTarget>> WEIGHTED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GrpcRouteAction.getter(GrpcRouteAction::weightedTargets)).setter(GrpcRouteAction.setter(Builder::weightedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weightedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WeightedTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHTED_TARGETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<WeightedTarget> weightedTargets;

    private GrpcRouteAction(BuilderImpl builder) {
        this.weightedTargets = builder.weightedTargets;
    }

    public List<WeightedTarget> weightedTargets() {
        return this.weightedTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedTargets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRouteAction)) {
            return false;
        }
        GrpcRouteAction other = (GrpcRouteAction)obj;
        return Objects.equals(this.weightedTargets(), other.weightedTargets());
    }

    public String toString() {
        return ToString.builder((String)"GrpcRouteAction").add("WeightedTargets", this.weightedTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "weightedTargets": {
                return Optional.ofNullable(clazz.cast(this.weightedTargets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcRouteAction, T> g) {
        return obj -> g.apply((GrpcRouteAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WeightedTarget> weightedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRouteAction model) {
            this.weightedTargets(model.weightedTargets);
        }

        public final Collection<WeightedTarget.Builder> getWeightedTargets() {
            return this.weightedTargets != null ? (Collection)this.weightedTargets.stream().map(WeightedTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder weightedTargets(Collection<WeightedTarget> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copy(weightedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(WeightedTarget ... weightedTargets) {
            this.weightedTargets(Arrays.asList(weightedTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(Consumer<WeightedTarget.Builder> ... weightedTargets) {
            this.weightedTargets(Stream.of(weightedTargets).map(c -> (WeightedTarget)((WeightedTarget.Builder)WeightedTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWeightedTargets(Collection<WeightedTarget.BuilderImpl> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copyFromBuilder(weightedTargets);
        }

        public GrpcRouteAction build() {
            return new GrpcRouteAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrpcRouteAction> {
        public Builder weightedTargets(Collection<WeightedTarget> var1);

        public Builder weightedTargets(WeightedTarget ... var1);

        public Builder weightedTargets(Consumer<WeightedTarget.Builder> ... var1);
    }
}

