/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ChangeEvent;
import software.amazon.awssdk.services.applicationsignals.model.ListEntityEventsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListEntityEventsResponse;

public class ListEntityEventsPublisher
implements SdkPublisher<ListEntityEventsResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListEntityEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntityEventsPublisher(ApplicationSignalsAsyncClient client, ListEntityEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntityEventsPublisher(ApplicationSignalsAsyncClient client, ListEntityEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntityEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntityEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChangeEvent> changeEvents() {
        Function<ListEntityEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.changeEvents() != null) {
                return response.changeEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntityEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEntityEventsResponseFetcher
    implements AsyncPageFetcher<ListEntityEventsResponse> {
        private ListEntityEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntityEventsResponse> nextPage(ListEntityEventsResponse previousPage) {
            if (previousPage == null) {
                return ListEntityEventsPublisher.this.client.listEntityEvents(ListEntityEventsPublisher.this.firstRequest);
            }
            return ListEntityEventsPublisher.this.client.listEntityEvents((ListEntityEventsRequest)((Object)ListEntityEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

