/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupingAttributeDefinitionsRequest
extends ApplicationSignalsRequest
implements ToCopyableBuilder<Builder, ListGroupingAttributeDefinitionsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupingAttributeDefinitionsRequest.getter(ListGroupingAttributeDefinitionsRequest::nextToken)).setter(ListGroupingAttributeDefinitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(ListGroupingAttributeDefinitionsRequest.getter(ListGroupingAttributeDefinitionsRequest::awsAccountId)).setter(ListGroupingAttributeDefinitionsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AwsAccountId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeLinkedAccounts").getter(ListGroupingAttributeDefinitionsRequest.getter(ListGroupingAttributeDefinitionsRequest::includeLinkedAccounts)).setter(ListGroupingAttributeDefinitionsRequest.setter(Builder::includeLinkedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeLinkedAccounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AWS_ACCOUNT_ID_FIELD, INCLUDE_LINKED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGroupingAttributeDefinitionsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final String awsAccountId;
    private final Boolean includeLinkedAccounts;

    private ListGroupingAttributeDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.awsAccountId = builder.awsAccountId;
        this.includeLinkedAccounts = builder.includeLinkedAccounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final Boolean includeLinkedAccounts() {
        return this.includeLinkedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeLinkedAccounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingAttributeDefinitionsRequest)) {
            return false;
        }
        ListGroupingAttributeDefinitionsRequest other = (ListGroupingAttributeDefinitionsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.includeLinkedAccounts(), other.includeLinkedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupingAttributeDefinitionsRequest").add("NextToken", (Object)this.nextToken()).add("AwsAccountId", (Object)this.awsAccountId()).add("IncludeLinkedAccounts", (Object)this.includeLinkedAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "IncludeLinkedAccounts": {
                return Optional.ofNullable(clazz.cast(this.includeLinkedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("IncludeLinkedAccounts", INCLUDE_LINKED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingAttributeDefinitionsRequest, T> g) {
        return obj -> g.apply((ListGroupingAttributeDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private String awsAccountId;
        private Boolean includeLinkedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingAttributeDefinitionsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.awsAccountId(model.awsAccountId);
            this.includeLinkedAccounts(model.includeLinkedAccounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Boolean getIncludeLinkedAccounts() {
            return this.includeLinkedAccounts;
        }

        public final void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
        }

        @Override
        public final Builder includeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupingAttributeDefinitionsRequest build() {
            return new ListGroupingAttributeDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupingAttributeDefinitionsRequest> {
        public Builder nextToken(String var1);

        public Builder awsAccountId(String var1);

        public Builder includeLinkedAccounts(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

