/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsRequest;
import software.amazon.awssdk.services.applicationsignals.model.AuditTarget;
import software.amazon.awssdk.services.applicationsignals.model.AuditTargetsCopier;
import software.amazon.awssdk.services.applicationsignals.model.AuditorsCopier;
import software.amazon.awssdk.services.applicationsignals.model.DetailLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditFindingsRequest
extends ApplicationSignalsRequest
implements ToCopyableBuilder<Builder, ListAuditFindingsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::startTime)).setter(ListAuditFindingsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::endTime)).setter(ListAuditFindingsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndTime").build()}).build();
    private static final SdkField<List<String>> AUDITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Auditors").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::auditors)).setter(ListAuditFindingsRequest.setter(Builder::auditors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auditors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AuditTarget>> AUDIT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuditTargets").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::auditTargets)).setter(ListAuditFindingsRequest.setter(Builder::auditTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAIL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailLevel").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::detailLevelAsString)).setter(ListAuditFindingsRequest.setter(Builder::detailLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailLevel").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::nextToken)).setter(ListAuditFindingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAuditFindingsRequest.getter(ListAuditFindingsRequest::maxResults)).setter(ListAuditFindingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, AUDITORS_FIELD, AUDIT_TARGETS_FIELD, DETAIL_LEVEL_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAuditFindingsRequest.memberNameToFieldInitializer();
    private final Instant startTime;
    private final Instant endTime;
    private final List<String> auditors;
    private final List<AuditTarget> auditTargets;
    private final String detailLevel;
    private final String nextToken;
    private final Integer maxResults;

    private ListAuditFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.auditors = builder.auditors;
        this.auditTargets = builder.auditTargets;
        this.detailLevel = builder.detailLevel;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasAuditors() {
        return this.auditors != null && !(this.auditors instanceof SdkAutoConstructList);
    }

    public final List<String> auditors() {
        return this.auditors;
    }

    public final boolean hasAuditTargets() {
        return this.auditTargets != null && !(this.auditTargets instanceof SdkAutoConstructList);
    }

    public final List<AuditTarget> auditTargets() {
        return this.auditTargets;
    }

    public final DetailLevel detailLevel() {
        return DetailLevel.fromValue(this.detailLevel);
    }

    public final String detailLevelAsString() {
        return this.detailLevel;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditors() ? this.auditors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditTargets() ? this.auditTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsRequest)) {
            return false;
        }
        ListAuditFindingsRequest other = (ListAuditFindingsRequest)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasAuditors() == other.hasAuditors() && Objects.equals(this.auditors(), other.auditors()) && this.hasAuditTargets() == other.hasAuditTargets() && Objects.equals(this.auditTargets(), other.auditTargets()) && Objects.equals(this.detailLevelAsString(), other.detailLevelAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuditFindingsRequest").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Auditors", this.hasAuditors() ? this.auditors() : null).add("AuditTargets", this.hasAuditTargets() ? this.auditTargets() : null).add("DetailLevel", (Object)this.detailLevelAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Auditors": {
                return Optional.ofNullable(clazz.cast(this.auditors()));
            }
            case "AuditTargets": {
                return Optional.ofNullable(clazz.cast(this.auditTargets()));
            }
            case "DetailLevel": {
                return Optional.ofNullable(clazz.cast(this.detailLevelAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Auditors", AUDITORS_FIELD);
        map.put("AuditTargets", AUDIT_TARGETS_FIELD);
        map.put("DetailLevel", DETAIL_LEVEL_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsRequest, T> g) {
        return obj -> g.apply((ListAuditFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsRequest.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<String> auditors = DefaultSdkAutoConstructList.getInstance();
        private List<AuditTarget> auditTargets = DefaultSdkAutoConstructList.getInstance();
        private String detailLevel;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsRequest model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.auditors(model.auditors);
            this.auditTargets(model.auditTargets);
            this.detailLevel(model.detailLevel);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getAuditors() {
            if (this.auditors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.auditors;
        }

        public final void setAuditors(Collection<String> auditors) {
            this.auditors = AuditorsCopier.copy(auditors);
        }

        @Override
        public final Builder auditors(Collection<String> auditors) {
            this.auditors = AuditorsCopier.copy(auditors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditors(String ... auditors) {
            this.auditors(Arrays.asList(auditors));
            return this;
        }

        public final List<AuditTarget.Builder> getAuditTargets() {
            List<AuditTarget.Builder> result = AuditTargetsCopier.copyToBuilder(this.auditTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditTargets(Collection<AuditTarget.BuilderImpl> auditTargets) {
            this.auditTargets = AuditTargetsCopier.copyFromBuilder(auditTargets);
        }

        @Override
        public final Builder auditTargets(Collection<AuditTarget> auditTargets) {
            this.auditTargets = AuditTargetsCopier.copy(auditTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditTargets(AuditTarget ... auditTargets) {
            this.auditTargets(Arrays.asList(auditTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditTargets(Consumer<AuditTarget.Builder> ... auditTargets) {
            this.auditTargets(Stream.of(auditTargets).map(c -> (AuditTarget)((AuditTarget.Builder)AuditTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetailLevel() {
            return this.detailLevel;
        }

        public final void setDetailLevel(String detailLevel) {
            this.detailLevel = detailLevel;
        }

        @Override
        public final Builder detailLevel(String detailLevel) {
            this.detailLevel = detailLevel;
            return this;
        }

        @Override
        public final Builder detailLevel(DetailLevel detailLevel) {
            this.detailLevel(detailLevel == null ? null : detailLevel.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditFindingsRequest build() {
            return new ListAuditFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditFindingsRequest> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder auditors(Collection<String> var1);

        public Builder auditors(String ... var1);

        public Builder auditTargets(Collection<AuditTarget> var1);

        public Builder auditTargets(AuditTarget ... var1);

        public Builder auditTargets(Consumer<AuditTarget.Builder> ... var1);

        public Builder detailLevel(String var1);

        public Builder detailLevel(DetailLevel var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

