/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains identifying information for a service operation entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceOperationEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceOperationEntity.Builder, ServiceOperationEntity> {
    private static final SdkField<ServiceEntity> SERVICE_FIELD = SdkField.<ServiceEntity> builder(MarshallingType.SDK_POJO)
            .memberName("Service").getter(getter(ServiceOperationEntity::service)).setter(setter(Builder::service))
            .constructor(ServiceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(ServiceOperationEntity::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(ServiceOperationEntity::metricType)).setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD,
            OPERATION_FIELD, METRIC_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceEntity service;

    private final String operation;

    private final String metricType;

    private ServiceOperationEntity(BuilderImpl builder) {
        this.service = builder.service;
        this.operation = builder.operation;
        this.metricType = builder.metricType;
    }

    /**
     * <p>
     * The service entity that contains this operation.
     * </p>
     * 
     * @return The service entity that contains this operation.
     */
    public final ServiceEntity service() {
        return service;
    }

    /**
     * <p>
     * The name of the operation.
     * </p>
     * 
     * @return The name of the operation.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The type of metric associated with this service operation.
     * </p>
     * 
     * @return The type of metric associated with this service operation.
     */
    public final String metricType() {
        return metricType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(metricType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOperationEntity)) {
            return false;
        }
        ServiceOperationEntity other = (ServiceOperationEntity) obj;
        return Objects.equals(service(), other.service()) && Objects.equals(operation(), other.operation())
                && Objects.equals(metricType(), other.metricType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceOperationEntity").add("Service", service()).add("Operation", operation())
                .add("MetricType", metricType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Service", SERVICE_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("MetricType", METRIC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceOperationEntity, T> g) {
        return obj -> g.apply((ServiceOperationEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceOperationEntity> {
        /**
         * <p>
         * The service entity that contains this operation.
         * </p>
         * 
         * @param service
         *        The service entity that contains this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(ServiceEntity service);

        /**
         * <p>
         * The service entity that contains this operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceEntity.Builder} avoiding the need
         * to create one manually via {@link ServiceEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #service(ServiceEntity)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link ServiceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(ServiceEntity)
         */
        default Builder service(Consumer<ServiceEntity.Builder> service) {
            return service(ServiceEntity.builder().applyMutation(service).build());
        }

        /**
         * <p>
         * The name of the operation.
         * </p>
         * 
         * @param operation
         *        The name of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The type of metric associated with this service operation.
         * </p>
         * 
         * @param metricType
         *        The type of metric associated with this service operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricType(String metricType);
    }

    static final class BuilderImpl implements Builder {
        private ServiceEntity service;

        private String operation;

        private String metricType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceOperationEntity model) {
            service(model.service);
            operation(model.operation);
            metricType(model.metricType);
        }

        public final ServiceEntity.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(ServiceEntity.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(ServiceEntity service) {
            this.service = service;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public ServiceOperationEntity build() {
            return new ServiceOperationEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
