/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about an operation discovered by Application Signals. An operation is a specific
 * function performed by a service that was discovered by Application Signals, and is often an API that is called by an
 * upstream dependent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceOperation.Builder, ServiceOperation> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceOperation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField
            .<List<MetricReference>> builder(MarshallingType.LIST)
            .memberName("MetricReferences")
            .getter(getter(ServiceOperation::metricReferences))
            .setter(setter(Builder::metricReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            METRIC_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<MetricReference> metricReferences;

    private ServiceOperation(BuilderImpl builder) {
        this.name = builder.name;
        this.metricReferences = builder.metricReferences;
    }

    /**
     * <p>
     * The name of the operation, discovered by Application Signals.
     * </p>
     * 
     * @return The name of the operation, discovered by Application Signals.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricReferences() {
        return metricReferences != null && !(metricReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that each contain information about one metric associated with this service operation that
     * was discovered by Application Signals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricReferences} method.
     * </p>
     * 
     * @return An array of structures that each contain information about one metric associated with this service
     *         operation that was discovered by Application Signals.
     */
    public final List<MetricReference> metricReferences() {
        return metricReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricReferences() ? metricReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOperation)) {
            return false;
        }
        ServiceOperation other = (ServiceOperation) obj;
        return Objects.equals(name(), other.name()) && hasMetricReferences() == other.hasMetricReferences()
                && Objects.equals(metricReferences(), other.metricReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceOperation").add("Name", name())
                .add("MetricReferences", hasMetricReferences() ? metricReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MetricReferences":
            return Optional.ofNullable(clazz.cast(metricReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceOperation, T> g) {
        return obj -> g.apply((ServiceOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceOperation> {
        /**
         * <p>
         * The name of the operation, discovered by Application Signals.
         * </p>
         * 
         * @param name
         *        The name of the operation, discovered by Application Signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service operation
         * that was discovered by Application Signals.
         * </p>
         * 
         * @param metricReferences
         *        An array of structures that each contain information about one metric associated with this service
         *        operation that was discovered by Application Signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricReferences(Collection<MetricReference> metricReferences);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service operation
         * that was discovered by Application Signals.
         * </p>
         * 
         * @param metricReferences
         *        An array of structures that each contain information about one metric associated with this service
         *        operation that was discovered by Application Signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricReferences(MetricReference... metricReferences);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service operation
         * that was discovered by Application Signals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder#build()} is called
         * immediately and its result is passed to {@link #metricReferences(List<MetricReference>)}.
         * 
         * @param metricReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricReferences(java.util.Collection<MetricReference>)
         */
        Builder metricReferences(Consumer<MetricReference.Builder>... metricReferences);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceOperation model) {
            name(model.name);
            metricReferences(model.metricReferences);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference... metricReferences) {
            metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder>... metricReferences) {
            metricReferences(Stream.of(metricReferences).map(c -> MetricReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceOperation build() {
            return new ServiceOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
