/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutGroupingConfigurationRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<PutGroupingConfigurationRequest.Builder, PutGroupingConfigurationRequest> {
    private static final SdkField<List<GroupingAttributeDefinition>> GROUPING_ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<GroupingAttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupingAttributeDefinitions")
            .getter(getter(PutGroupingConfigurationRequest::groupingAttributeDefinitions))
            .setter(setter(Builder::groupingAttributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingAttributeDefinitions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupingAttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupingAttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUPING_ATTRIBUTE_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GroupingAttributeDefinition> groupingAttributeDefinitions;

    private PutGroupingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.groupingAttributeDefinitions = builder.groupingAttributeDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupingAttributeDefinitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGroupingAttributeDefinitions() {
        return groupingAttributeDefinitions != null && !(groupingAttributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of grouping attribute definitions that specify how services should be grouped. Each definition includes
     * a friendly name, source keys to derive the grouping value from, and an optional default value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupingAttributeDefinitions} method.
     * </p>
     * 
     * @return An array of grouping attribute definitions that specify how services should be grouped. Each definition
     *         includes a friendly name, source keys to derive the grouping value from, and an optional default value.
     */
    public final List<GroupingAttributeDefinition> groupingAttributeDefinitions() {
        return groupingAttributeDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupingAttributeDefinitions() ? groupingAttributeDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGroupingConfigurationRequest)) {
            return false;
        }
        PutGroupingConfigurationRequest other = (PutGroupingConfigurationRequest) obj;
        return hasGroupingAttributeDefinitions() == other.hasGroupingAttributeDefinitions()
                && Objects.equals(groupingAttributeDefinitions(), other.groupingAttributeDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutGroupingConfigurationRequest")
                .add("GroupingAttributeDefinitions", hasGroupingAttributeDefinitions() ? groupingAttributeDefinitions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupingAttributeDefinitions":
            return Optional.ofNullable(clazz.cast(groupingAttributeDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupingAttributeDefinitions", GROUPING_ATTRIBUTE_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutGroupingConfigurationRequest, T> g) {
        return obj -> g.apply((PutGroupingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutGroupingConfigurationRequest> {
        /**
         * <p>
         * An array of grouping attribute definitions that specify how services should be grouped. Each definition
         * includes a friendly name, source keys to derive the grouping value from, and an optional default value.
         * </p>
         * 
         * @param groupingAttributeDefinitions
         *        An array of grouping attribute definitions that specify how services should be grouped. Each
         *        definition includes a friendly name, source keys to derive the grouping value from, and an optional
         *        default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingAttributeDefinitions(Collection<GroupingAttributeDefinition> groupingAttributeDefinitions);

        /**
         * <p>
         * An array of grouping attribute definitions that specify how services should be grouped. Each definition
         * includes a friendly name, source keys to derive the grouping value from, and an optional default value.
         * </p>
         * 
         * @param groupingAttributeDefinitions
         *        An array of grouping attribute definitions that specify how services should be grouped. Each
         *        definition includes a friendly name, source keys to derive the grouping value from, and an optional
         *        default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingAttributeDefinitions(GroupingAttributeDefinition... groupingAttributeDefinitions);

        /**
         * <p>
         * An array of grouping attribute definitions that specify how services should be grouped. Each definition
         * includes a friendly name, source keys to derive the grouping value from, and an optional default value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #groupingAttributeDefinitions(List<GroupingAttributeDefinition>)}.
         * 
         * @param groupingAttributeDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingAttributeDefinitions(java.util.Collection<GroupingAttributeDefinition>)
         */
        Builder groupingAttributeDefinitions(Consumer<GroupingAttributeDefinition.Builder>... groupingAttributeDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private List<GroupingAttributeDefinition> groupingAttributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGroupingConfigurationRequest model) {
            super(model);
            groupingAttributeDefinitions(model.groupingAttributeDefinitions);
        }

        public final List<GroupingAttributeDefinition.Builder> getGroupingAttributeDefinitions() {
            List<GroupingAttributeDefinition.Builder> result = GroupingAttributeDefinitionsCopier
                    .copyToBuilder(this.groupingAttributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingAttributeDefinitions(
                Collection<GroupingAttributeDefinition.BuilderImpl> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = GroupingAttributeDefinitionsCopier.copyFromBuilder(groupingAttributeDefinitions);
        }

        @Override
        public final Builder groupingAttributeDefinitions(Collection<GroupingAttributeDefinition> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = GroupingAttributeDefinitionsCopier.copy(groupingAttributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeDefinitions(GroupingAttributeDefinition... groupingAttributeDefinitions) {
            groupingAttributeDefinitions(Arrays.asList(groupingAttributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeDefinitions(
                Consumer<GroupingAttributeDefinition.Builder>... groupingAttributeDefinitions) {
            groupingAttributeDefinitions(Stream.of(groupingAttributeDefinitions)
                    .map(c -> GroupingAttributeDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGroupingConfigurationRequest build() {
            return new PutGroupingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
