/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the metric that is used as the "good request" or "bad request" value for a request-based SLO.
 * This value observed for the metric defined in <code>TotalRequestCountMetric</code> is divided by the number found for
 * <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this SLO tracks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoredRequestCountMetricDataQueries implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoredRequestCountMetricDataQueries.Builder, MonitoredRequestCountMetricDataQueries> {
    private static final SdkField<List<MetricDataQuery>> GOOD_COUNT_METRIC_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("GoodCountMetric")
            .getter(getter(MonitoredRequestCountMetricDataQueries::goodCountMetric))
            .setter(setter(Builder::goodCountMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoodCountMetric").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricDataQuery>> BAD_COUNT_METRIC_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("BadCountMetric")
            .getter(getter(MonitoredRequestCountMetricDataQueries::badCountMetric))
            .setter(setter(Builder::badCountMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BadCountMetric").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GOOD_COUNT_METRIC_FIELD,
            BAD_COUNT_METRIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MetricDataQuery> goodCountMetric;

    private final List<MetricDataQuery> badCountMetric;

    private final Type type;

    private MonitoredRequestCountMetricDataQueries(BuilderImpl builder) {
        this.goodCountMetric = builder.goodCountMetric;
        this.badCountMetric = builder.badCountMetric;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the GoodCountMetric property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGoodCountMetric() {
        return goodCountMetric != null && !(goodCountMetric instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you want to count "good requests" to determine the percentage of successful requests for this request-based
     * SLO, specify the metric to use as "good requests" in this structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGoodCountMetric} method.
     * </p>
     * 
     * @return If you want to count "good requests" to determine the percentage of successful requests for this
     *         request-based SLO, specify the metric to use as "good requests" in this structure.
     */
    public final List<MetricDataQuery> goodCountMetric() {
        return goodCountMetric;
    }

    /**
     * For responses, this returns true if the service returned a value for the BadCountMetric property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBadCountMetric() {
        return badCountMetric != null && !(badCountMetric instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you want to count "bad requests" to determine the percentage of successful requests for this request-based
     * SLO, specify the metric to use as "bad requests" in this structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBadCountMetric} method.
     * </p>
     * 
     * @return If you want to count "bad requests" to determine the percentage of successful requests for this
     *         request-based SLO, specify the metric to use as "bad requests" in this structure.
     */
    public final List<MetricDataQuery> badCountMetric() {
        return badCountMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGoodCountMetric() ? goodCountMetric() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBadCountMetric() ? badCountMetric() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoredRequestCountMetricDataQueries)) {
            return false;
        }
        MonitoredRequestCountMetricDataQueries other = (MonitoredRequestCountMetricDataQueries) obj;
        return hasGoodCountMetric() == other.hasGoodCountMetric() && Objects.equals(goodCountMetric(), other.goodCountMetric())
                && hasBadCountMetric() == other.hasBadCountMetric() && Objects.equals(badCountMetric(), other.badCountMetric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoredRequestCountMetricDataQueries")
                .add("GoodCountMetric", hasGoodCountMetric() ? goodCountMetric() : null)
                .add("BadCountMetric", hasBadCountMetric() ? badCountMetric() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GoodCountMetric":
            return Optional.ofNullable(clazz.cast(goodCountMetric()));
        case "BadCountMetric":
            return Optional.ofNullable(clazz.cast(badCountMetric()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #goodCountMetric()} initialized to the given value.
     *
     * <p>
     * If you want to count "good requests" to determine the percentage of successful requests for this request-based
     * SLO, specify the metric to use as "good requests" in this structure.
     * </p>
     * 
     * @param goodCountMetric
     *        If you want to count "good requests" to determine the percentage of successful requests for this
     *        request-based SLO, specify the metric to use as "good requests" in this structure.
     */
    public static MonitoredRequestCountMetricDataQueries fromGoodCountMetric(List<MetricDataQuery> goodCountMetric) {
        return builder().goodCountMetric(goodCountMetric).build();
    }

    /**
     * Create an instance of this class with {@link #badCountMetric()} initialized to the given value.
     *
     * <p>
     * If you want to count "bad requests" to determine the percentage of successful requests for this request-based
     * SLO, specify the metric to use as "bad requests" in this structure.
     * </p>
     * 
     * @param badCountMetric
     *        If you want to count "bad requests" to determine the percentage of successful requests for this
     *        request-based SLO, specify the metric to use as "bad requests" in this structure.
     */
    public static MonitoredRequestCountMetricDataQueries fromBadCountMetric(List<MetricDataQuery> badCountMetric) {
        return builder().badCountMetric(badCountMetric).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GoodCountMetric", GOOD_COUNT_METRIC_FIELD);
        map.put("BadCountMetric", BAD_COUNT_METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoredRequestCountMetricDataQueries, T> g) {
        return obj -> g.apply((MonitoredRequestCountMetricDataQueries) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoredRequestCountMetricDataQueries> {
        /**
         * <p>
         * If you want to count "good requests" to determine the percentage of successful requests for this
         * request-based SLO, specify the metric to use as "good requests" in this structure.
         * </p>
         * 
         * @param goodCountMetric
         *        If you want to count "good requests" to determine the percentage of successful requests for this
         *        request-based SLO, specify the metric to use as "good requests" in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder goodCountMetric(Collection<MetricDataQuery> goodCountMetric);

        /**
         * <p>
         * If you want to count "good requests" to determine the percentage of successful requests for this
         * request-based SLO, specify the metric to use as "good requests" in this structure.
         * </p>
         * 
         * @param goodCountMetric
         *        If you want to count "good requests" to determine the percentage of successful requests for this
         *        request-based SLO, specify the metric to use as "good requests" in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder goodCountMetric(MetricDataQuery... goodCountMetric);

        /**
         * <p>
         * If you want to count "good requests" to determine the percentage of successful requests for this
         * request-based SLO, specify the metric to use as "good requests" in this structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #goodCountMetric(List<MetricDataQuery>)}.
         * 
         * @param goodCountMetric
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #goodCountMetric(java.util.Collection<MetricDataQuery>)
         */
        Builder goodCountMetric(Consumer<MetricDataQuery.Builder>... goodCountMetric);

        /**
         * <p>
         * If you want to count "bad requests" to determine the percentage of successful requests for this request-based
         * SLO, specify the metric to use as "bad requests" in this structure.
         * </p>
         * 
         * @param badCountMetric
         *        If you want to count "bad requests" to determine the percentage of successful requests for this
         *        request-based SLO, specify the metric to use as "bad requests" in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badCountMetric(Collection<MetricDataQuery> badCountMetric);

        /**
         * <p>
         * If you want to count "bad requests" to determine the percentage of successful requests for this request-based
         * SLO, specify the metric to use as "bad requests" in this structure.
         * </p>
         * 
         * @param badCountMetric
         *        If you want to count "bad requests" to determine the percentage of successful requests for this
         *        request-based SLO, specify the metric to use as "bad requests" in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badCountMetric(MetricDataQuery... badCountMetric);

        /**
         * <p>
         * If you want to count "bad requests" to determine the percentage of successful requests for this request-based
         * SLO, specify the metric to use as "bad requests" in this structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #badCountMetric(List<MetricDataQuery>)}.
         * 
         * @param badCountMetric
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #badCountMetric(java.util.Collection<MetricDataQuery>)
         */
        Builder badCountMetric(Consumer<MetricDataQuery.Builder>... badCountMetric);
    }

    static final class BuilderImpl implements Builder {
        private List<MetricDataQuery> goodCountMetric = DefaultSdkAutoConstructList.getInstance();

        private List<MetricDataQuery> badCountMetric = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoredRequestCountMetricDataQueries model) {
            goodCountMetric(model.goodCountMetric);
            badCountMetric(model.badCountMetric);
        }

        public final List<MetricDataQuery.Builder> getGoodCountMetric() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.goodCountMetric);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGoodCountMetric(Collection<MetricDataQuery.BuilderImpl> goodCountMetric) {
            Object oldValue = this.goodCountMetric;
            this.goodCountMetric = MetricDataQueriesCopier.copyFromBuilder(goodCountMetric);
            handleUnionValueChange(Type.GOOD_COUNT_METRIC, oldValue, this.goodCountMetric);
        }

        @Override
        public final Builder goodCountMetric(Collection<MetricDataQuery> goodCountMetric) {
            Object oldValue = this.goodCountMetric;
            this.goodCountMetric = MetricDataQueriesCopier.copy(goodCountMetric);
            handleUnionValueChange(Type.GOOD_COUNT_METRIC, oldValue, this.goodCountMetric);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder goodCountMetric(MetricDataQuery... goodCountMetric) {
            goodCountMetric(Arrays.asList(goodCountMetric));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder goodCountMetric(Consumer<MetricDataQuery.Builder>... goodCountMetric) {
            goodCountMetric(Stream.of(goodCountMetric).map(c -> MetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MetricDataQuery.Builder> getBadCountMetric() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.badCountMetric);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBadCountMetric(Collection<MetricDataQuery.BuilderImpl> badCountMetric) {
            Object oldValue = this.badCountMetric;
            this.badCountMetric = MetricDataQueriesCopier.copyFromBuilder(badCountMetric);
            handleUnionValueChange(Type.BAD_COUNT_METRIC, oldValue, this.badCountMetric);
        }

        @Override
        public final Builder badCountMetric(Collection<MetricDataQuery> badCountMetric) {
            Object oldValue = this.badCountMetric;
            this.badCountMetric = MetricDataQueriesCopier.copy(badCountMetric);
            handleUnionValueChange(Type.BAD_COUNT_METRIC, oldValue, this.badCountMetric);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder badCountMetric(MetricDataQuery... badCountMetric) {
            badCountMetric(Arrays.asList(badCountMetric));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder badCountMetric(Consumer<MetricDataQuery.Builder>... badCountMetric) {
            badCountMetric(Stream.of(badCountMetric).map(c -> MetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MonitoredRequestCountMetricDataQueries build() {
            return new MonitoredRequestCountMetricDataQueries(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MonitoredRequestCountMetricDataQueries#type()
     */
    public enum Type {
        GOOD_COUNT_METRIC,

        BAD_COUNT_METRIC,

        UNKNOWN_TO_SDK_VERSION
    }
}
