/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntityEventsResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<ListEntityEventsResponse.Builder, ListEntityEventsResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListEntityEventsResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListEntityEventsResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<ChangeEvent>> CHANGE_EVENTS_FIELD = SdkField
            .<List<ChangeEvent>> builder(MarshallingType.LIST)
            .memberName("ChangeEvents")
            .getter(getter(ListEntityEventsResponse::changeEvents))
            .setter(setter(Builder::changeEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEntityEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, CHANGE_EVENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final List<ChangeEvent> changeEvents;

    private final String nextToken;

    private ListEntityEventsResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.changeEvents = builder.changeEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time period that the returned change events apply to. When used in a raw HTTP Query API, it is
     * formatted as epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * 
     * @return The start of the time period that the returned change events apply to. When used in a raw HTTP Query API,
     *         it is formatted as epoch time in seconds. For example: <code>1698778057</code>
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period that the returned change events apply to. When used in a raw HTTP Query API, it is
     * formatted as epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * 
     * @return The end of the time period that the returned change events apply to. When used in a raw HTTP Query API,
     *         it is formatted as epoch time in seconds. For example: <code>1698778057</code>
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangeEvents() {
        return changeEvents != null && !(changeEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure contains information about one change event that occurred for the
     * specified entity during the requested time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeEvents} method.
     * </p>
     * 
     * @return An array of structures, where each structure contains information about one change event that occurred
     *         for the specified entity during the requested time period.
     */
    public final List<ChangeEvent> changeEvents() {
        return changeEvents;
    }

    /**
     * <p>
     * Include this value in your next use of this API to get the next set of change events.
     * </p>
     * 
     * @return Include this value in your next use of this API to get the next set of change events.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeEvents() ? changeEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityEventsResponse)) {
            return false;
        }
        ListEntityEventsResponse other = (ListEntityEventsResponse) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasChangeEvents() == other.hasChangeEvents() && Objects.equals(changeEvents(), other.changeEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEntityEventsResponse").add("StartTime", startTime()).add("EndTime", endTime())
                .add("ChangeEvents", hasChangeEvents() ? changeEvents() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ChangeEvents":
            return Optional.ofNullable(clazz.cast(changeEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ChangeEvents", CHANGE_EVENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntityEventsResponse, T> g) {
        return obj -> g.apply((ListEntityEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEntityEventsResponse> {
        /**
         * <p>
         * The start of the time period that the returned change events apply to. When used in a raw HTTP Query API, it
         * is formatted as epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * 
         * @param startTime
         *        The start of the time period that the returned change events apply to. When used in a raw HTTP Query
         *        API, it is formatted as epoch time in seconds. For example: <code>1698778057</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period that the returned change events apply to. When used in a raw HTTP Query API, it is
         * formatted as epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * 
         * @param endTime
         *        The end of the time period that the returned change events apply to. When used in a raw HTTP Query
         *        API, it is formatted as epoch time in seconds. For example: <code>1698778057</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An array of structures, where each structure contains information about one change event that occurred for
         * the specified entity during the requested time period.
         * </p>
         * 
         * @param changeEvents
         *        An array of structures, where each structure contains information about one change event that occurred
         *        for the specified entity during the requested time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeEvents(Collection<ChangeEvent> changeEvents);

        /**
         * <p>
         * An array of structures, where each structure contains information about one change event that occurred for
         * the specified entity during the requested time period.
         * </p>
         * 
         * @param changeEvents
         *        An array of structures, where each structure contains information about one change event that occurred
         *        for the specified entity during the requested time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeEvents(ChangeEvent... changeEvents);

        /**
         * <p>
         * An array of structures, where each structure contains information about one change event that occurred for
         * the specified entity during the requested time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #changeEvents(List<ChangeEvent>)}.
         * 
         * @param changeEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ChangeEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeEvents(java.util.Collection<ChangeEvent>)
         */
        Builder changeEvents(Consumer<ChangeEvent.Builder>... changeEvents);

        /**
         * <p>
         * Include this value in your next use of this API to get the next set of change events.
         * </p>
         * 
         * @param nextToken
         *        Include this value in your next use of this API to get the next set of change events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private List<ChangeEvent> changeEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityEventsResponse model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            changeEvents(model.changeEvents);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ChangeEvent.Builder> getChangeEvents() {
            List<ChangeEvent.Builder> result = ChangeEventsCopier.copyToBuilder(this.changeEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeEvents(Collection<ChangeEvent.BuilderImpl> changeEvents) {
            this.changeEvents = ChangeEventsCopier.copyFromBuilder(changeEvents);
        }

        @Override
        public final Builder changeEvents(Collection<ChangeEvent> changeEvents) {
            this.changeEvents = ChangeEventsCopier.copy(changeEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeEvents(ChangeEvent... changeEvents) {
            changeEvents(Arrays.asList(changeEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeEvents(Consumer<ChangeEvent.Builder>... changeEvents) {
            changeEvents(Stream.of(changeEvents).map(c -> ChangeEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntityEventsResponse build() {
            return new ListEntityEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
