/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a connection between two nodes in a dependency graph, showing the relationship and
 * characteristics of the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Edge implements SdkPojo, Serializable, ToCopyableBuilder<Edge.Builder, Edge> {
    private static final SdkField<String> SOURCE_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceNodeId").getter(getter(Edge::sourceNodeId)).setter(setter(Builder::sourceNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceNodeId").build()).build();

    private static final SdkField<String> DESTINATION_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationNodeId").getter(getter(Edge::destinationNodeId)).setter(setter(Builder::destinationNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationNodeId").build()).build();

    private static final SdkField<Double> DURATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Duration").getter(getter(Edge::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(Edge::connectionTypeAsString)).setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NODE_ID_FIELD,
            DESTINATION_NODE_ID_FIELD, DURATION_FIELD, CONNECTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceNodeId;

    private final String destinationNodeId;

    private final Double duration;

    private final String connectionType;

    private Edge(BuilderImpl builder) {
        this.sourceNodeId = builder.sourceNodeId;
        this.destinationNodeId = builder.destinationNodeId;
        this.duration = builder.duration;
        this.connectionType = builder.connectionType;
    }

    /**
     * <p>
     * The identifier of the source node in this edge connection.
     * </p>
     * 
     * @return The identifier of the source node in this edge connection.
     */
    public final String sourceNodeId() {
        return sourceNodeId;
    }

    /**
     * <p>
     * The identifier of the destination node in this edge connection.
     * </p>
     * 
     * @return The identifier of the destination node in this edge connection.
     */
    public final String destinationNodeId() {
        return destinationNodeId;
    }

    /**
     * <p>
     * The duration or latency associated with this connection, if applicable.
     * </p>
     * 
     * @return The duration or latency associated with this connection, if applicable.
     */
    public final Double duration() {
        return duration;
    }

    /**
     * <p>
     * The type of connection between the nodes, indicating the nature of the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of connection between the nodes, indicating the nature of the relationship.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of connection between the nodes, indicating the nature of the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of connection between the nodes, indicating the nature of the relationship.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge) obj;
        return Objects.equals(sourceNodeId(), other.sourceNodeId())
                && Objects.equals(destinationNodeId(), other.destinationNodeId()) && Objects.equals(duration(), other.duration())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Edge").add("SourceNodeId", sourceNodeId()).add("DestinationNodeId", destinationNodeId())
                .add("Duration", duration()).add("ConnectionType", connectionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceNodeId":
            return Optional.ofNullable(clazz.cast(sourceNodeId()));
        case "DestinationNodeId":
            return Optional.ofNullable(clazz.cast(destinationNodeId()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceNodeId", SOURCE_NODE_ID_FIELD);
        map.put("DestinationNodeId", DESTINATION_NODE_ID_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Edge, T> g) {
        return obj -> g.apply((Edge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Edge> {
        /**
         * <p>
         * The identifier of the source node in this edge connection.
         * </p>
         * 
         * @param sourceNodeId
         *        The identifier of the source node in this edge connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNodeId(String sourceNodeId);

        /**
         * <p>
         * The identifier of the destination node in this edge connection.
         * </p>
         * 
         * @param destinationNodeId
         *        The identifier of the destination node in this edge connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationNodeId(String destinationNodeId);

        /**
         * <p>
         * The duration or latency associated with this connection, if applicable.
         * </p>
         * 
         * @param duration
         *        The duration or latency associated with this connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Double duration);

        /**
         * <p>
         * The type of connection between the nodes, indicating the nature of the relationship.
         * </p>
         * 
         * @param connectionType
         *        The type of connection between the nodes, indicating the nature of the relationship.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of connection between the nodes, indicating the nature of the relationship.
         * </p>
         * 
         * @param connectionType
         *        The type of connection between the nodes, indicating the nature of the relationship.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);
    }

    static final class BuilderImpl implements Builder {
        private String sourceNodeId;

        private String destinationNodeId;

        private Double duration;

        private String connectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            sourceNodeId(model.sourceNodeId);
            destinationNodeId(model.destinationNodeId);
            duration(model.duration);
            connectionType(model.connectionType);
        }

        public final String getSourceNodeId() {
            return sourceNodeId;
        }

        public final void setSourceNodeId(String sourceNodeId) {
            this.sourceNodeId = sourceNodeId;
        }

        @Override
        public final Builder sourceNodeId(String sourceNodeId) {
            this.sourceNodeId = sourceNodeId;
            return this;
        }

        public final String getDestinationNodeId() {
            return destinationNodeId;
        }

        public final void setDestinationNodeId(String destinationNodeId) {
            this.destinationNodeId = destinationNodeId;
        }

        @Override
        public final Builder destinationNodeId(String destinationNodeId) {
            this.destinationNodeId = destinationNodeId;
            return this;
        }

        public final Double getDuration() {
            return duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        @Override
        public Edge build() {
            return new Edge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
