/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateExclusionWindowsResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<BatchUpdateExclusionWindowsResponse.Builder, BatchUpdateExclusionWindowsResponse> {
    private static final SdkField<List<String>> SLO_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SloIds")
            .getter(getter(BatchUpdateExclusionWindowsResponse::sloIds))
            .setter(setter(Builder::sloIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchUpdateExclusionWindowsError>> ERRORS_FIELD = SdkField
            .<List<BatchUpdateExclusionWindowsError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchUpdateExclusionWindowsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateExclusionWindowsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateExclusionWindowsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_IDS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> sloIds;

    private final List<BatchUpdateExclusionWindowsError> errors;

    private BatchUpdateExclusionWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.sloIds = builder.sloIds;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the SloIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSloIds() {
        return sloIds != null && !(sloIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of SLO IDs that were successfully processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSloIds} method.
     * </p>
     * 
     * @return The list of SLO IDs that were successfully processed.
     */
    public final List<String> sloIds() {
        return sloIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors that occurred while processing the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors that occurred while processing the request.
     */
    public final List<BatchUpdateExclusionWindowsError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSloIds() ? sloIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateExclusionWindowsResponse)) {
            return false;
        }
        BatchUpdateExclusionWindowsResponse other = (BatchUpdateExclusionWindowsResponse) obj;
        return hasSloIds() == other.hasSloIds() && Objects.equals(sloIds(), other.sloIds()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateExclusionWindowsResponse").add("SloIds", hasSloIds() ? sloIds() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SloIds":
            return Optional.ofNullable(clazz.cast(sloIds()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SloIds", SLO_IDS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateExclusionWindowsResponse, T> g) {
        return obj -> g.apply((BatchUpdateExclusionWindowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateExclusionWindowsResponse> {
        /**
         * <p>
         * The list of SLO IDs that were successfully processed.
         * </p>
         * 
         * @param sloIds
         *        The list of SLO IDs that were successfully processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloIds(Collection<String> sloIds);

        /**
         * <p>
         * The list of SLO IDs that were successfully processed.
         * </p>
         * 
         * @param sloIds
         *        The list of SLO IDs that were successfully processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sloIds(String... sloIds);

        /**
         * <p>
         * A list of errors that occurred while processing the request.
         * </p>
         * 
         * @param errors
         *        A list of errors that occurred while processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchUpdateExclusionWindowsError> errors);

        /**
         * <p>
         * A list of errors that occurred while processing the request.
         * </p>
         * 
         * @param errors
         *        A list of errors that occurred while processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchUpdateExclusionWindowsError... errors);

        /**
         * <p>
         * A list of errors that occurred while processing the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsError.Builder#build()}
         * is called immediately and its result is passed to {@link #errors(List<BatchUpdateExclusionWindowsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchUpdateExclusionWindowsError>)
         */
        Builder errors(Consumer<BatchUpdateExclusionWindowsError.Builder>... errors);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private List<String> sloIds = DefaultSdkAutoConstructList.getInstance();

        private List<BatchUpdateExclusionWindowsError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateExclusionWindowsResponse model) {
            super(model);
            sloIds(model.sloIds);
            errors(model.errors);
        }

        public final Collection<String> getSloIds() {
            if (sloIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sloIds;
        }

        public final void setSloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
        }

        @Override
        public final Builder sloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloIds(String... sloIds) {
            sloIds(Arrays.asList(sloIds));
            return this;
        }

        public final List<BatchUpdateExclusionWindowsError.Builder> getErrors() {
            List<BatchUpdateExclusionWindowsError.Builder> result = BatchUpdateExclusionWindowsErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchUpdateExclusionWindowsError.BuilderImpl> errors) {
            this.errors = BatchUpdateExclusionWindowsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchUpdateExclusionWindowsError> errors) {
            this.errors = BatchUpdateExclusionWindowsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchUpdateExclusionWindowsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchUpdateExclusionWindowsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchUpdateExclusionWindowsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateExclusionWindowsResponse build() {
            return new BatchUpdateExclusionWindowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
