/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AttributeFiltersCopier {
    static List<AttributeFilter> copy(Collection<? extends AttributeFilter> attributeFiltersParam) {
        List<AttributeFilter> list;
        if (attributeFiltersParam == null || attributeFiltersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AttributeFilter> modifiableList = new ArrayList<>(attributeFiltersParam.size());
            attributeFiltersParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AttributeFilter> copyFromBuilder(Collection<? extends AttributeFilter.Builder> attributeFiltersParam) {
        List<AttributeFilter> list;
        if (attributeFiltersParam == null || attributeFiltersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AttributeFilter> modifiableList = new ArrayList<>(attributeFiltersParam.size());
            attributeFiltersParam.forEach(entry -> {
                AttributeFilter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AttributeFilter.Builder> copyToBuilder(Collection<? extends AttributeFilter> attributeFiltersParam) {
        List<AttributeFilter.Builder> list;
        if (attributeFiltersParam == null || attributeFiltersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AttributeFilter.Builder> modifiableList = new ArrayList<>(attributeFiltersParam.size());
            attributeFiltersParam.forEach(entry -> {
                AttributeFilter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
