/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.ServiceEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceOperationEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceOperationEntity> {
    private static final SdkField<ServiceEntity> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Service").getter(ServiceOperationEntity.getter(ServiceOperationEntity::service)).setter(ServiceOperationEntity.setter(Builder::service)).constructor(ServiceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(ServiceOperationEntity.getter(ServiceOperationEntity::operation)).setter(ServiceOperationEntity.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricType").getter(ServiceOperationEntity.getter(ServiceOperationEntity::metricType)).setter(ServiceOperationEntity.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, OPERATION_FIELD, METRIC_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceOperationEntity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ServiceEntity service;
    private final String operation;
    private final String metricType;

    private ServiceOperationEntity(BuilderImpl builder) {
        this.service = builder.service;
        this.operation = builder.operation;
        this.metricType = builder.metricType;
    }

    public final ServiceEntity service() {
        return this.service;
    }

    public final String operation() {
        return this.operation;
    }

    public final String metricType() {
        return this.metricType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOperationEntity)) {
            return false;
        }
        ServiceOperationEntity other = (ServiceOperationEntity)obj;
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.metricType(), other.metricType());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceOperationEntity").add("Service", (Object)this.service()).add("Operation", (Object)this.operation()).add("MetricType", (Object)this.metricType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "MetricType": {
                return Optional.ofNullable(clazz.cast(this.metricType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Service", SERVICE_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("MetricType", METRIC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceOperationEntity, T> g) {
        return obj -> g.apply((ServiceOperationEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceEntity service;
        private String operation;
        private String metricType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceOperationEntity model) {
            this.service(model.service);
            this.operation(model.operation);
            this.metricType(model.metricType);
        }

        public final ServiceEntity.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        public final void setService(ServiceEntity.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(ServiceEntity service) {
            this.service = service;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        public ServiceOperationEntity build() {
            return new ServiceOperationEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceOperationEntity> {
        public Builder service(ServiceEntity var1);

        default public Builder service(Consumer<ServiceEntity.Builder> service) {
            return this.service((ServiceEntity)((ServiceEntity.Builder)ServiceEntity.builder().applyMutation(service)).build());
        }

        public Builder operation(String var1);

        public Builder metricType(String var1);
    }
}

