/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.AttributeFilterValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeFilter> {
    private static final SdkField<String> ATTRIBUTE_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeFilterName").getter(AttributeFilter.getter(AttributeFilter::attributeFilterName)).setter(AttributeFilter.setter(Builder::attributeFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilterName").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeFilterValues").getter(AttributeFilter.getter(AttributeFilter::attributeFilterValues)).setter(AttributeFilter.setter(Builder::attributeFilterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FILTER_NAME_FIELD, ATTRIBUTE_FILTER_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeFilterName;
    private final List<String> attributeFilterValues;

    private AttributeFilter(BuilderImpl builder) {
        this.attributeFilterName = builder.attributeFilterName;
        this.attributeFilterValues = builder.attributeFilterValues;
    }

    public final String attributeFilterName() {
        return this.attributeFilterName;
    }

    public final boolean hasAttributeFilterValues() {
        return this.attributeFilterValues != null && !(this.attributeFilterValues instanceof SdkAutoConstructList);
    }

    public final List<String> attributeFilterValues() {
        return this.attributeFilterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeFilterValues() ? this.attributeFilterValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeFilter)) {
            return false;
        }
        AttributeFilter other = (AttributeFilter)obj;
        return Objects.equals(this.attributeFilterName(), other.attributeFilterName()) && this.hasAttributeFilterValues() == other.hasAttributeFilterValues() && Objects.equals(this.attributeFilterValues(), other.attributeFilterValues());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeFilter").add("AttributeFilterName", (Object)this.attributeFilterName()).add("AttributeFilterValues", this.hasAttributeFilterValues() ? this.attributeFilterValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeFilterName": {
                return Optional.ofNullable(clazz.cast(this.attributeFilterName()));
            }
            case "AttributeFilterValues": {
                return Optional.ofNullable(clazz.cast(this.attributeFilterValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeFilterName", ATTRIBUTE_FILTER_NAME_FIELD);
        map.put("AttributeFilterValues", ATTRIBUTE_FILTER_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeFilter, T> g) {
        return obj -> g.apply((AttributeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeFilterName;
        private List<String> attributeFilterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeFilter model) {
            this.attributeFilterName(model.attributeFilterName);
            this.attributeFilterValues(model.attributeFilterValues);
        }

        public final String getAttributeFilterName() {
            return this.attributeFilterName;
        }

        public final void setAttributeFilterName(String attributeFilterName) {
            this.attributeFilterName = attributeFilterName;
        }

        @Override
        public final Builder attributeFilterName(String attributeFilterName) {
            this.attributeFilterName = attributeFilterName;
            return this;
        }

        public final Collection<String> getAttributeFilterValues() {
            if (this.attributeFilterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeFilterValues;
        }

        public final void setAttributeFilterValues(Collection<String> attributeFilterValues) {
            this.attributeFilterValues = AttributeFilterValuesCopier.copy(attributeFilterValues);
        }

        @Override
        public final Builder attributeFilterValues(Collection<String> attributeFilterValues) {
            this.attributeFilterValues = AttributeFilterValuesCopier.copy(attributeFilterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeFilterValues(String ... attributeFilterValues) {
            this.attributeFilterValues(Arrays.asList(attributeFilterValues));
            return this;
        }

        public AttributeFilter build() {
            return new AttributeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeFilter> {
        public Builder attributeFilterName(String var1);

        public Builder attributeFilterValues(Collection<String> var1);

        public Builder attributeFilterValues(String ... var1);
    }
}

