/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.MetricReference;
import software.amazon.awssdk.services.applicationsignals.model.MetricReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceOperation> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ServiceOperation.getter(ServiceOperation::name)).setter(ServiceOperation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricReferences").getter(ServiceOperation.getter(ServiceOperation::metricReferences)).setter(ServiceOperation.setter(Builder::metricReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<MetricReference> metricReferences;

    private ServiceOperation(BuilderImpl builder) {
        this.name = builder.name;
        this.metricReferences = builder.metricReferences;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasMetricReferences() {
        return this.metricReferences != null && !(this.metricReferences instanceof SdkAutoConstructList);
    }

    public final List<MetricReference> metricReferences() {
        return this.metricReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricReferences() ? this.metricReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOperation)) {
            return false;
        }
        ServiceOperation other = (ServiceOperation)obj;
        return Objects.equals(this.name(), other.name()) && this.hasMetricReferences() == other.hasMetricReferences() && Objects.equals(this.metricReferences(), other.metricReferences());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceOperation").add("Name", (Object)this.name()).add("MetricReferences", this.hasMetricReferences() ? this.metricReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MetricReferences": {
                return Optional.ofNullable(clazz.cast(this.metricReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceOperation, T> g) {
        return obj -> g.apply((ServiceOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceOperation model) {
            this.name(model.name);
            this.metricReferences(model.metricReferences);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference ... metricReferences) {
            this.metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder> ... metricReferences) {
            this.metricReferences(Stream.of(metricReferences).map(c -> (MetricReference)((MetricReference.Builder)MetricReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceOperation build() {
            return new ServiceOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceOperation> {
        public Builder name(String var1);

        public Builder metricReferences(Collection<MetricReference> var1);

        public Builder metricReferences(MetricReference ... var1);

        public Builder metricReferences(Consumer<MetricReference.Builder> ... var1);
    }
}

