/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow;
import software.amazon.awssdk.services.applicationsignals.model.ExclusionWindowsCopier;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateExclusionWindowsRequest
extends ApplicationSignalsRequest
implements ToCopyableBuilder<Builder, BatchUpdateExclusionWindowsRequest> {
    private static final SdkField<List<String>> SLO_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SloIds").getter(BatchUpdateExclusionWindowsRequest.getter(BatchUpdateExclusionWindowsRequest::sloIds)).setter(BatchUpdateExclusionWindowsRequest.setter(Builder::sloIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExclusionWindow>> ADD_EXCLUSION_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddExclusionWindows").getter(BatchUpdateExclusionWindowsRequest.getter(BatchUpdateExclusionWindowsRequest::addExclusionWindows)).setter(BatchUpdateExclusionWindowsRequest.setter(Builder::addExclusionWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddExclusionWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExclusionWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExclusionWindow>> REMOVE_EXCLUSION_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveExclusionWindows").getter(BatchUpdateExclusionWindowsRequest.getter(BatchUpdateExclusionWindowsRequest::removeExclusionWindows)).setter(BatchUpdateExclusionWindowsRequest.setter(Builder::removeExclusionWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveExclusionWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExclusionWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_IDS_FIELD, ADD_EXCLUSION_WINDOWS_FIELD, REMOVE_EXCLUSION_WINDOWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateExclusionWindowsRequest.memberNameToFieldInitializer();
    private final List<String> sloIds;
    private final List<ExclusionWindow> addExclusionWindows;
    private final List<ExclusionWindow> removeExclusionWindows;

    private BatchUpdateExclusionWindowsRequest(BuilderImpl builder) {
        super(builder);
        this.sloIds = builder.sloIds;
        this.addExclusionWindows = builder.addExclusionWindows;
        this.removeExclusionWindows = builder.removeExclusionWindows;
    }

    public final boolean hasSloIds() {
        return this.sloIds != null && !(this.sloIds instanceof SdkAutoConstructList);
    }

    public final List<String> sloIds() {
        return this.sloIds;
    }

    public final boolean hasAddExclusionWindows() {
        return this.addExclusionWindows != null && !(this.addExclusionWindows instanceof SdkAutoConstructList);
    }

    public final List<ExclusionWindow> addExclusionWindows() {
        return this.addExclusionWindows;
    }

    public final boolean hasRemoveExclusionWindows() {
        return this.removeExclusionWindows != null && !(this.removeExclusionWindows instanceof SdkAutoConstructList);
    }

    public final List<ExclusionWindow> removeExclusionWindows() {
        return this.removeExclusionWindows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSloIds() ? this.sloIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddExclusionWindows() ? this.addExclusionWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveExclusionWindows() ? this.removeExclusionWindows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateExclusionWindowsRequest)) {
            return false;
        }
        BatchUpdateExclusionWindowsRequest other = (BatchUpdateExclusionWindowsRequest)((Object)obj);
        return this.hasSloIds() == other.hasSloIds() && Objects.equals(this.sloIds(), other.sloIds()) && this.hasAddExclusionWindows() == other.hasAddExclusionWindows() && Objects.equals(this.addExclusionWindows(), other.addExclusionWindows()) && this.hasRemoveExclusionWindows() == other.hasRemoveExclusionWindows() && Objects.equals(this.removeExclusionWindows(), other.removeExclusionWindows());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateExclusionWindowsRequest").add("SloIds", this.hasSloIds() ? this.sloIds() : null).add("AddExclusionWindows", this.hasAddExclusionWindows() ? this.addExclusionWindows() : null).add("RemoveExclusionWindows", this.hasRemoveExclusionWindows() ? this.removeExclusionWindows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SloIds": {
                return Optional.ofNullable(clazz.cast(this.sloIds()));
            }
            case "AddExclusionWindows": {
                return Optional.ofNullable(clazz.cast(this.addExclusionWindows()));
            }
            case "RemoveExclusionWindows": {
                return Optional.ofNullable(clazz.cast(this.removeExclusionWindows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SloIds", SLO_IDS_FIELD);
        map.put("AddExclusionWindows", ADD_EXCLUSION_WINDOWS_FIELD);
        map.put("RemoveExclusionWindows", REMOVE_EXCLUSION_WINDOWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateExclusionWindowsRequest, T> g) {
        return obj -> g.apply((BatchUpdateExclusionWindowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsRequest.BuilderImpl
    implements Builder {
        private List<String> sloIds = DefaultSdkAutoConstructList.getInstance();
        private List<ExclusionWindow> addExclusionWindows = DefaultSdkAutoConstructList.getInstance();
        private List<ExclusionWindow> removeExclusionWindows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateExclusionWindowsRequest model) {
            super(model);
            this.sloIds(model.sloIds);
            this.addExclusionWindows(model.addExclusionWindows);
            this.removeExclusionWindows(model.removeExclusionWindows);
        }

        public final Collection<String> getSloIds() {
            if (this.sloIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sloIds;
        }

        public final void setSloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
        }

        @Override
        public final Builder sloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloIds(String ... sloIds) {
            this.sloIds(Arrays.asList(sloIds));
            return this;
        }

        public final List<ExclusionWindow.Builder> getAddExclusionWindows() {
            List<ExclusionWindow.Builder> result = ExclusionWindowsCopier.copyToBuilder(this.addExclusionWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddExclusionWindows(Collection<ExclusionWindow.BuilderImpl> addExclusionWindows) {
            this.addExclusionWindows = ExclusionWindowsCopier.copyFromBuilder(addExclusionWindows);
        }

        @Override
        public final Builder addExclusionWindows(Collection<ExclusionWindow> addExclusionWindows) {
            this.addExclusionWindows = ExclusionWindowsCopier.copy(addExclusionWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addExclusionWindows(ExclusionWindow ... addExclusionWindows) {
            this.addExclusionWindows(Arrays.asList(addExclusionWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addExclusionWindows(Consumer<ExclusionWindow.Builder> ... addExclusionWindows) {
            this.addExclusionWindows(Stream.of(addExclusionWindows).map(c -> (ExclusionWindow)((ExclusionWindow.Builder)ExclusionWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ExclusionWindow.Builder> getRemoveExclusionWindows() {
            List<ExclusionWindow.Builder> result = ExclusionWindowsCopier.copyToBuilder(this.removeExclusionWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveExclusionWindows(Collection<ExclusionWindow.BuilderImpl> removeExclusionWindows) {
            this.removeExclusionWindows = ExclusionWindowsCopier.copyFromBuilder(removeExclusionWindows);
        }

        @Override
        public final Builder removeExclusionWindows(Collection<ExclusionWindow> removeExclusionWindows) {
            this.removeExclusionWindows = ExclusionWindowsCopier.copy(removeExclusionWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeExclusionWindows(ExclusionWindow ... removeExclusionWindows) {
            this.removeExclusionWindows(Arrays.asList(removeExclusionWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeExclusionWindows(Consumer<ExclusionWindow.Builder> ... removeExclusionWindows) {
            this.removeExclusionWindows(Stream.of(removeExclusionWindows).map(c -> (ExclusionWindow)((ExclusionWindow.Builder)ExclusionWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateExclusionWindowsRequest build() {
            return new BatchUpdateExclusionWindowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationSignalsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateExclusionWindowsRequest> {
        public Builder sloIds(Collection<String> var1);

        public Builder sloIds(String ... var1);

        public Builder addExclusionWindows(Collection<ExclusionWindow> var1);

        public Builder addExclusionWindows(ExclusionWindow ... var1);

        public Builder addExclusionWindows(Consumer<ExclusionWindow.Builder> ... var1);

        public Builder removeExclusionWindows(Collection<ExclusionWindow> var1);

        public Builder removeExclusionWindows(ExclusionWindow ... var1);

        public Builder removeExclusionWindows(Consumer<ExclusionWindow.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

