/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.CalendarInterval;
import software.amazon.awssdk.services.applicationsignals.model.RollingInterval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Interval
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Interval> {
    private static final SdkField<RollingInterval> ROLLING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollingInterval").getter(Interval.getter(Interval::rollingInterval)).setter(Interval.setter(Builder::rollingInterval)).constructor(RollingInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingInterval").build()}).build();
    private static final SdkField<CalendarInterval> CALENDAR_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CalendarInterval").getter(Interval.getter(Interval::calendarInterval)).setter(Interval.setter(Builder::calendarInterval)).constructor(CalendarInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLING_INTERVAL_FIELD, CALENDAR_INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RollingInterval", ROLLING_INTERVAL_FIELD);
            this.put("CalendarInterval", CALENDAR_INTERVAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RollingInterval rollingInterval;
    private final CalendarInterval calendarInterval;
    private final Type type;

    private Interval(BuilderImpl builder) {
        this.rollingInterval = builder.rollingInterval;
        this.calendarInterval = builder.calendarInterval;
        this.type = builder.type;
    }

    public final RollingInterval rollingInterval() {
        return this.rollingInterval;
    }

    public final CalendarInterval calendarInterval() {
        return this.calendarInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.calendarInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        return Objects.equals(this.rollingInterval(), other.rollingInterval()) && Objects.equals(this.calendarInterval(), other.calendarInterval());
    }

    public final String toString() {
        return ToString.builder((String)"Interval").add("RollingInterval", (Object)this.rollingInterval()).add("CalendarInterval", (Object)this.calendarInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RollingInterval": {
                return Optional.ofNullable(clazz.cast(this.rollingInterval()));
            }
            case "CalendarInterval": {
                return Optional.ofNullable(clazz.cast(this.calendarInterval()));
            }
        }
        return Optional.empty();
    }

    public static Interval fromRollingInterval(RollingInterval rollingInterval) {
        return (Interval)Interval.builder().rollingInterval(rollingInterval).build();
    }

    public static Interval fromRollingInterval(Consumer<RollingInterval.Builder> rollingInterval) {
        RollingInterval.Builder builder = RollingInterval.builder();
        rollingInterval.accept(builder);
        return Interval.fromRollingInterval((RollingInterval)builder.build());
    }

    public static Interval fromCalendarInterval(CalendarInterval calendarInterval) {
        return (Interval)Interval.builder().calendarInterval(calendarInterval).build();
    }

    public static Interval fromCalendarInterval(Consumer<CalendarInterval.Builder> calendarInterval) {
        CalendarInterval.Builder builder = CalendarInterval.builder();
        calendarInterval.accept(builder);
        return Interval.fromCalendarInterval((CalendarInterval)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Interval, T> g) {
        return obj -> g.apply((Interval)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ROLLING_INTERVAL,
        CALENDAR_INTERVAL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RollingInterval rollingInterval;
        private CalendarInterval calendarInterval;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Interval model) {
            this.rollingInterval(model.rollingInterval);
            this.calendarInterval(model.calendarInterval);
        }

        public final RollingInterval.Builder getRollingInterval() {
            return this.rollingInterval != null ? this.rollingInterval.toBuilder() : null;
        }

        public final void setRollingInterval(RollingInterval.BuilderImpl rollingInterval) {
            RollingInterval oldValue = this.rollingInterval;
            this.rollingInterval = rollingInterval != null ? rollingInterval.build() : null;
            this.handleUnionValueChange(Type.ROLLING_INTERVAL, oldValue, this.rollingInterval);
        }

        @Override
        public final Builder rollingInterval(RollingInterval rollingInterval) {
            RollingInterval oldValue = this.rollingInterval;
            this.rollingInterval = rollingInterval;
            this.handleUnionValueChange(Type.ROLLING_INTERVAL, oldValue, this.rollingInterval);
            return this;
        }

        public final CalendarInterval.Builder getCalendarInterval() {
            return this.calendarInterval != null ? this.calendarInterval.toBuilder() : null;
        }

        public final void setCalendarInterval(CalendarInterval.BuilderImpl calendarInterval) {
            CalendarInterval oldValue = this.calendarInterval;
            this.calendarInterval = calendarInterval != null ? calendarInterval.build() : null;
            this.handleUnionValueChange(Type.CALENDAR_INTERVAL, oldValue, this.calendarInterval);
        }

        @Override
        public final Builder calendarInterval(CalendarInterval calendarInterval) {
            CalendarInterval oldValue = this.calendarInterval;
            this.calendarInterval = calendarInterval;
            this.handleUnionValueChange(Type.CALENDAR_INTERVAL, oldValue, this.calendarInterval);
            return this;
        }

        public Interval build() {
            return new Interval(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Interval> {
        public Builder rollingInterval(RollingInterval var1);

        default public Builder rollingInterval(Consumer<RollingInterval.Builder> rollingInterval) {
            return this.rollingInterval((RollingInterval)((RollingInterval.Builder)RollingInterval.builder().applyMutation(rollingInterval)).build());
        }

        public Builder calendarInterval(CalendarInterval var1);

        default public Builder calendarInterval(Consumer<CalendarInterval.Builder> calendarInterval) {
            return this.calendarInterval((CalendarInterval)((CalendarInterval.Builder)CalendarInterval.builder().applyMutation(calendarInterval)).build());
        }
    }
}

