/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependency;

public class ListServiceDependenciesPublisher
implements SdkPublisher<ListServiceDependenciesResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListServiceDependenciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceDependenciesPublisher(ApplicationSignalsAsyncClient client, ListServiceDependenciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceDependenciesPublisher(ApplicationSignalsAsyncClient client, ListServiceDependenciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceDependenciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceDependenciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceDependency> serviceDependencies() {
        Function<ListServiceDependenciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceDependencies() != null) {
                return response.serviceDependencies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceDependenciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceDependenciesResponseFetcher
    implements AsyncPageFetcher<ListServiceDependenciesResponse> {
        private ListServiceDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceDependenciesResponse> nextPage(ListServiceDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceDependenciesPublisher.this.client.listServiceDependencies(ListServiceDependenciesPublisher.this.firstRequest);
            }
            return ListServiceDependenciesPublisher.this.client.listServiceDependencies((ListServiceDependenciesRequest)((Object)ListServiceDependenciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

