/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorMetricType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelIndicatorMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelIndicatorMetric> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KeyAttributes").getter(ServiceLevelIndicatorMetric.getter(ServiceLevelIndicatorMetric::keyAttributes)).setter(ServiceLevelIndicatorMetric.setter(Builder::keyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(ServiceLevelIndicatorMetric.getter(ServiceLevelIndicatorMetric::operationName)).setter(ServiceLevelIndicatorMetric.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()}).build();
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricType").getter(ServiceLevelIndicatorMetric.getter(ServiceLevelIndicatorMetric::metricTypeAsString)).setter(ServiceLevelIndicatorMetric.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()}).build();
    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDataQueries").getter(ServiceLevelIndicatorMetric.getter(ServiceLevelIndicatorMetric::metricDataQueries)).setter(ServiceLevelIndicatorMetric.setter(Builder::metricDataQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, OPERATION_NAME_FIELD, METRIC_TYPE_FIELD, METRIC_DATA_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
            this.put("OperationName", OPERATION_NAME_FIELD);
            this.put("MetricType", METRIC_TYPE_FIELD);
            this.put("MetricDataQueries", METRIC_DATA_QUERIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, String> keyAttributes;
    private final String operationName;
    private final String metricType;
    private final List<MetricDataQuery> metricDataQueries;

    private ServiceLevelIndicatorMetric(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.metricType = builder.metricType;
        this.metricDataQueries = builder.metricDataQueries;
    }

    public final boolean hasKeyAttributes() {
        return this.keyAttributes != null && !(this.keyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyAttributes() {
        return this.keyAttributes;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final ServiceLevelIndicatorMetricType metricType() {
        return ServiceLevelIndicatorMetricType.fromValue(this.metricType);
    }

    public final String metricTypeAsString() {
        return this.metricType;
    }

    public final boolean hasMetricDataQueries() {
        return this.metricDataQueries != null && !(this.metricDataQueries instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> metricDataQueries() {
        return this.metricDataQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyAttributes() ? this.keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataQueries() ? this.metricDataQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicatorMetric)) {
            return false;
        }
        ServiceLevelIndicatorMetric other = (ServiceLevelIndicatorMetric)obj;
        return this.hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.metricTypeAsString(), other.metricTypeAsString()) && this.hasMetricDataQueries() == other.hasMetricDataQueries() && Objects.equals(this.metricDataQueries(), other.metricDataQueries());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelIndicatorMetric").add("KeyAttributes", this.hasKeyAttributes() ? this.keyAttributes() : null).add("OperationName", (Object)this.operationName()).add("MetricType", (Object)this.metricTypeAsString()).add("MetricDataQueries", this.hasMetricDataQueries() ? this.metricDataQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "MetricType": {
                return Optional.ofNullable(clazz.cast(this.metricTypeAsString()));
            }
            case "MetricDataQueries": {
                return Optional.ofNullable(clazz.cast(this.metricDataQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicatorMetric, T> g) {
        return obj -> g.apply((ServiceLevelIndicatorMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String operationName;
        private String metricType;
        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicatorMetric model) {
            this.keyAttributes(model.keyAttributes);
            this.operationName(model.operationName);
            this.metricType(model.metricType);
            this.metricDataQueries(model.metricDataQueries);
        }

        public final Map<String, String> getKeyAttributes() {
            if (this.keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(ServiceLevelIndicatorMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery ... metricDataQueries) {
            this.metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... metricDataQueries) {
            this.metricDataQueries(Stream.of(metricDataQueries).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceLevelIndicatorMetric build() {
            return new ServiceLevelIndicatorMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelIndicatorMetric> {
        public Builder keyAttributes(Map<String, String> var1);

        public Builder operationName(String var1);

        public Builder metricType(String var1);

        public Builder metricType(ServiceLevelIndicatorMetricType var1);

        public Builder metricDataQueries(Collection<MetricDataQuery> var1);

        public Builder metricDataQueries(MetricDataQuery ... var1);

        public Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... var1);
    }
}

