/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorComparisonOperator;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorMetricConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelIndicatorConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelIndicatorConfig> {
    private static final SdkField<ServiceLevelIndicatorMetricConfig> SLI_METRIC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SliMetricConfig").getter(ServiceLevelIndicatorConfig.getter(ServiceLevelIndicatorConfig::sliMetricConfig)).setter(ServiceLevelIndicatorConfig.setter(Builder::sliMetricConfig)).constructor(ServiceLevelIndicatorMetricConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliMetricConfig").build()}).build();
    private static final SdkField<Double> METRIC_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricThreshold").getter(ServiceLevelIndicatorConfig.getter(ServiceLevelIndicatorConfig::metricThreshold)).setter(ServiceLevelIndicatorConfig.setter(Builder::metricThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricThreshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(ServiceLevelIndicatorConfig.getter(ServiceLevelIndicatorConfig::comparisonOperatorAsString)).setter(ServiceLevelIndicatorConfig.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLI_METRIC_CONFIG_FIELD, METRIC_THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SliMetricConfig", SLI_METRIC_CONFIG_FIELD);
            this.put("MetricThreshold", METRIC_THRESHOLD_FIELD);
            this.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ServiceLevelIndicatorMetricConfig sliMetricConfig;
    private final Double metricThreshold;
    private final String comparisonOperator;

    private ServiceLevelIndicatorConfig(BuilderImpl builder) {
        this.sliMetricConfig = builder.sliMetricConfig;
        this.metricThreshold = builder.metricThreshold;
        this.comparisonOperator = builder.comparisonOperator;
    }

    public final ServiceLevelIndicatorMetricConfig sliMetricConfig() {
        return this.sliMetricConfig;
    }

    public final Double metricThreshold() {
        return this.metricThreshold;
    }

    public final ServiceLevelIndicatorComparisonOperator comparisonOperator() {
        return ServiceLevelIndicatorComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sliMetricConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicatorConfig)) {
            return false;
        }
        ServiceLevelIndicatorConfig other = (ServiceLevelIndicatorConfig)obj;
        return Objects.equals(this.sliMetricConfig(), other.sliMetricConfig()) && Objects.equals(this.metricThreshold(), other.metricThreshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelIndicatorConfig").add("SliMetricConfig", (Object)this.sliMetricConfig()).add("MetricThreshold", (Object)this.metricThreshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SliMetricConfig": {
                return Optional.ofNullable(clazz.cast(this.sliMetricConfig()));
            }
            case "MetricThreshold": {
                return Optional.ofNullable(clazz.cast(this.metricThreshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicatorConfig, T> g) {
        return obj -> g.apply((ServiceLevelIndicatorConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceLevelIndicatorMetricConfig sliMetricConfig;
        private Double metricThreshold;
        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicatorConfig model) {
            this.sliMetricConfig(model.sliMetricConfig);
            this.metricThreshold(model.metricThreshold);
            this.comparisonOperator(model.comparisonOperator);
        }

        public final ServiceLevelIndicatorMetricConfig.Builder getSliMetricConfig() {
            return this.sliMetricConfig != null ? this.sliMetricConfig.toBuilder() : null;
        }

        public final void setSliMetricConfig(ServiceLevelIndicatorMetricConfig.BuilderImpl sliMetricConfig) {
            this.sliMetricConfig = sliMetricConfig != null ? sliMetricConfig.build() : null;
        }

        @Override
        public final Builder sliMetricConfig(ServiceLevelIndicatorMetricConfig sliMetricConfig) {
            this.sliMetricConfig = sliMetricConfig;
            return this;
        }

        public final Double getMetricThreshold() {
            return this.metricThreshold;
        }

        public final void setMetricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
        }

        @Override
        public final Builder metricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public ServiceLevelIndicatorConfig build() {
            return new ServiceLevelIndicatorConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelIndicatorConfig> {
        public Builder sliMetricConfig(ServiceLevelIndicatorMetricConfig var1);

        default public Builder sliMetricConfig(Consumer<ServiceLevelIndicatorMetricConfig.Builder> sliMetricConfig) {
            return this.sliMetricConfig((ServiceLevelIndicatorMetricConfig)((ServiceLevelIndicatorMetricConfig.Builder)ServiceLevelIndicatorMetricConfig.builder().applyMutation(sliMetricConfig)).build());
        }

        public Builder metricThreshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator var1);
    }
}

