/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.Interval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Goal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Goal> {
    private static final SdkField<Interval> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interval").getter(Goal.getter(Goal::interval)).setter(Goal.setter(Builder::interval)).constructor(Interval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<Double> ATTAINMENT_GOAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AttainmentGoal").getter(Goal.getter(Goal::attainmentGoal)).setter(Goal.setter(Builder::attainmentGoal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttainmentGoal").build()}).build();
    private static final SdkField<Double> WARNING_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("WarningThreshold").getter(Goal.getter(Goal::warningThreshold)).setter(Goal.setter(Builder::warningThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD, ATTAINMENT_GOAL_FIELD, WARNING_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Interval", INTERVAL_FIELD);
            this.put("AttainmentGoal", ATTAINMENT_GOAL_FIELD);
            this.put("WarningThreshold", WARNING_THRESHOLD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Interval interval;
    private final Double attainmentGoal;
    private final Double warningThreshold;

    private Goal(BuilderImpl builder) {
        this.interval = builder.interval;
        this.attainmentGoal = builder.attainmentGoal;
        this.warningThreshold = builder.warningThreshold;
    }

    public final Interval interval() {
        return this.interval;
    }

    public final Double attainmentGoal() {
        return this.attainmentGoal;
    }

    public final Double warningThreshold() {
        return this.warningThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.attainmentGoal());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Goal)) {
            return false;
        }
        Goal other = (Goal)obj;
        return Objects.equals(this.interval(), other.interval()) && Objects.equals(this.attainmentGoal(), other.attainmentGoal()) && Objects.equals(this.warningThreshold(), other.warningThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"Goal").add("Interval", (Object)this.interval()).add("AttainmentGoal", (Object)this.attainmentGoal()).add("WarningThreshold", (Object)this.warningThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "AttainmentGoal": {
                return Optional.ofNullable(clazz.cast(this.attainmentGoal()));
            }
            case "WarningThreshold": {
                return Optional.ofNullable(clazz.cast(this.warningThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Goal, T> g) {
        return obj -> g.apply((Goal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Interval interval;
        private Double attainmentGoal;
        private Double warningThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Goal model) {
            this.interval(model.interval);
            this.attainmentGoal(model.attainmentGoal);
            this.warningThreshold(model.warningThreshold);
        }

        public final Interval.Builder getInterval() {
            return this.interval != null ? this.interval.toBuilder() : null;
        }

        public final void setInterval(Interval.BuilderImpl interval) {
            this.interval = interval != null ? interval.build() : null;
        }

        @Override
        public final Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public final Double getAttainmentGoal() {
            return this.attainmentGoal;
        }

        public final void setAttainmentGoal(Double attainmentGoal) {
            this.attainmentGoal = attainmentGoal;
        }

        @Override
        public final Builder attainmentGoal(Double attainmentGoal) {
            this.attainmentGoal = attainmentGoal;
            return this;
        }

        public final Double getWarningThreshold() {
            return this.warningThreshold;
        }

        public final void setWarningThreshold(Double warningThreshold) {
            this.warningThreshold = warningThreshold;
        }

        @Override
        public final Builder warningThreshold(Double warningThreshold) {
            this.warningThreshold = warningThreshold;
            return this;
        }

        public Goal build() {
            return new Goal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Goal> {
        public Builder interval(Interval var1);

        default public Builder interval(Consumer<Interval.Builder> interval) {
            return this.interval((Interval)((Interval.Builder)Interval.builder().applyMutation(interval)).build());
        }

        public Builder attainmentGoal(Double var1);

        public Builder warningThreshold(Double var1);
    }
}

